/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.SqlFactory;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class DistinctQueryOperation
implements QueryOperation {
    private static final String INPUT_ALIAS = "$$T_DISTINCT";
    private final QueryOperation child;

    public DistinctQueryOperation(QueryOperation child) {
        this.child = child;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.child.getResolvedSchema();
    }

    @Override
    public String asSummaryString() {
        return OperationUtils.formatWithChildren("Distinct", Collections.emptyMap(), this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public String asSerializableString(SqlFactory sqlFactory) {
        return String.format("SELECT DISTINCT %s FROM (%s\n) %s", OperationUtils.formatSelectColumns(this.getResolvedSchema(), INPUT_ALIAS), OperationUtils.indent(this.child.asSerializableString(sqlFactory)), INPUT_ALIAS);
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.singletonList(this.child);
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

