/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.api.internal.TableResultUtils;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;

@Internal
public class DescribeFunctionOperation
implements Operation,
ExecutableOperation {
    private final UnresolvedIdentifier sqlIdentifier;
    private final boolean isExtended;

    public DescribeFunctionOperation(UnresolvedIdentifier sqlIdentifier, boolean isExtended) {
        this.sqlIdentifier = sqlIdentifier;
        this.isExtended = isExtended;
    }

    public UnresolvedIdentifier getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("identifier", this.sqlIdentifier);
        params.put("isExtended", this.isExtended);
        return OperationUtils.formatWithChildren("DESCRIBE FUNCTION", params, Collections.emptyList(), Operation::asSummaryString);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        Optional<ContextResolvedFunction> functionOpt = ctx.getFunctionCatalog().lookupFunction(this.sqlIdentifier);
        if (!functionOpt.isPresent()) {
            throw new ValidationException(String.format("Function with the identifier '%s' doesn't exist.", this.sqlIdentifier.asSummaryString()));
        }
        ContextResolvedFunction function = functionOpt.get();
        CatalogFunction catalogFunction = function.getCatalogFunction();
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        rows.add(Arrays.asList("is system function", String.valueOf(catalogFunction == null)));
        rows.add(Arrays.asList("is temporary", String.valueOf(function.isTemporary())));
        if (catalogFunction != null) {
            rows.add(Arrays.asList("class name", catalogFunction.getClassName()));
            rows.add(Arrays.asList("function language", catalogFunction.getFunctionLanguage().toString()));
            rows.add(Arrays.asList("resource uris", catalogFunction.getFunctionResources().toString()));
        }
        if (this.isExtended) {
            FunctionDefinition definition = function.getDefinition();
            rows.add(Arrays.asList("kind", definition.getKind().toString()));
            rows.add(Arrays.asList("requirements", definition.getRequirements().toString()));
            rows.add(Arrays.asList("is deterministic", String.valueOf(definition.isDeterministic())));
            rows.add(Arrays.asList("supports constant folding", String.valueOf(definition.supportsConstantFolding())));
            rows.add(Arrays.asList("signature", TypeInferenceUtil.generateSignature((TypeInference)definition.getTypeInference(ctx.getCatalogManager().getDataTypeFactory()), (String)function.toString(), (FunctionDefinition)definition)));
        }
        return TableResultUtils.buildTableResult(new String[]{"info name", "info value"}, new DataType[]{DataTypes.STRING(), DataTypes.STRING()}, (Object[][])rows.stream().map(List::toArray).toArray(x$0 -> new Object[x$0][]));
    }
}

