/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.SqlFactory;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;
import org.apache.flink.table.operations.utils.OperationExpressionsUtils;

@Internal
public class AggregateQueryOperation
implements QueryOperation {
    private static final String INPUT_ALIAS = "$$T_AGG";
    private final List<ResolvedExpression> groupingExpressions;
    private final List<ResolvedExpression> aggregateExpressions;
    private final QueryOperation child;
    private final ResolvedSchema resolvedSchema;

    public AggregateQueryOperation(List<ResolvedExpression> groupingExpressions, List<ResolvedExpression> aggregateExpressions, QueryOperation child, ResolvedSchema resolvedSchema) {
        this.groupingExpressions = groupingExpressions;
        this.aggregateExpressions = aggregateExpressions;
        this.child = child;
        this.resolvedSchema = resolvedSchema;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("group", this.groupingExpressions);
        args.put("agg", this.aggregateExpressions);
        return OperationUtils.formatWithChildren("Aggregate", args, this.getChildren(), Operation::asSummaryString);
    }

    public List<ResolvedExpression> getGroupingExpressions() {
        return this.groupingExpressions;
    }

    public List<ResolvedExpression> getAggregateExpressions() {
        return this.aggregateExpressions;
    }

    @Override
    public String asSerializableString(SqlFactory sqlFactory) {
        String groupingExprs = this.getGroupingExprs(sqlFactory);
        return String.format("SELECT %s FROM (%s\n) %s\nGROUP BY %s", Stream.concat(this.groupingExpressions.stream(), this.aggregateExpressions.stream()).map(expr -> OperationExpressionsUtils.scopeReferencesWithAlias(INPUT_ALIAS, expr)).map(resolvedExpression -> resolvedExpression.asSerializableString(sqlFactory)).collect(Collectors.joining(", ")), OperationUtils.indent(this.child.asSerializableString(sqlFactory)), INPUT_ALIAS, groupingExprs);
    }

    private String getGroupingExprs(SqlFactory sqlFactory) {
        if (this.groupingExpressions.isEmpty()) {
            return "1";
        }
        return this.groupingExpressions.stream().map(expr -> OperationExpressionsUtils.scopeReferencesWithAlias(INPUT_ALIAS, expr)).map(resolvedExpression -> resolvedExpression.asSerializableString(sqlFactory)).collect(Collectors.joining(", "));
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.singletonList(this.child);
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

