/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test.program;

import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableRuntimeException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.test.program.TestStep;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;

public final class FailingSqlTestStep
implements TestStep {
    public final String sql;
    public final Class<? extends Exception> expectedException;
    public final String expectedErrorMessage;

    FailingSqlTestStep(String sql, Class<? extends Exception> expectedException, String expectedErrorMessage) {
        Preconditions.checkArgument((expectedException == ValidationException.class || expectedException == TableRuntimeException.class ? 1 : 0) != 0, (Object)"Usually a SQL query should fail with either validation or runtime exception. Otherwise this might require an update to the exception design.");
        this.sql = sql;
        this.expectedException = expectedException;
        this.expectedErrorMessage = expectedErrorMessage;
    }

    @Override
    public TestStep.TestKind getKind() {
        return TestStep.TestKind.FAILING_SQL;
    }

    public void apply(TableEnvironment env) {
        Assertions.assertThatThrownBy(() -> env.executeSql(this.sql).await()).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(this.expectedException, (String)this.expectedErrorMessage)});
    }
}

