/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.CatalogDescriptor;
import org.apache.flink.table.catalog.CatalogStore;
import org.apache.flink.table.catalog.GenericInMemoryCatalogStore;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

public class GenericInMemoryCatalogStoreTest {
    @Test
    void testStoreAndGet() {
        GenericInMemoryCatalogStore catalogStore = new GenericInMemoryCatalogStore();
        catalogStore.open();
        catalogStore.storeCatalog("catalog1", CatalogDescriptor.of((String)"catalog1", (Configuration)new Configuration()));
        AssertionsForClassTypes.assertThat((boolean)catalogStore.getCatalog("catalog1").isPresent()).isTrue();
        AssertionsForClassTypes.assertThat((boolean)catalogStore.contains("catalog1")).isTrue();
        catalogStore.removeCatalog("catalog1", true);
        AssertionsForClassTypes.assertThat((boolean)catalogStore.contains("catalog1")).isFalse();
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> GenericInMemoryCatalogStoreTest.lambda$testStoreAndGet$0((CatalogStore)catalogStore)).isInstanceOf(CatalogException.class)).hasMessageContaining("Catalog catalog1 does not exist in the catalog store.");
        catalogStore.close();
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> GenericInMemoryCatalogStoreTest.lambda$testStoreAndGet$1((CatalogStore)catalogStore)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("CatalogStore is not opened yet.");
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> GenericInMemoryCatalogStoreTest.lambda$testStoreAndGet$2((CatalogStore)catalogStore)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("CatalogStore is not opened yet.");
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> GenericInMemoryCatalogStoreTest.lambda$testStoreAndGet$3((CatalogStore)catalogStore)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("CatalogStore is not opened yet.");
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> GenericInMemoryCatalogStoreTest.lambda$testStoreAndGet$4((CatalogStore)catalogStore)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("CatalogStore is not opened yet.");
    }

    private static /* synthetic */ void lambda$testStoreAndGet$4(CatalogStore catalogStore) throws Throwable {
        catalogStore.listCatalogs();
    }

    private static /* synthetic */ void lambda$testStoreAndGet$3(CatalogStore catalogStore) throws Throwable {
        catalogStore.contains("catalog1");
    }

    private static /* synthetic */ void lambda$testStoreAndGet$2(CatalogStore catalogStore) throws Throwable {
        catalogStore.removeCatalog("catalog1", false);
    }

    private static /* synthetic */ void lambda$testStoreAndGet$1(CatalogStore catalogStore) throws Throwable {
        catalogStore.storeCatalog("catalog1", CatalogDescriptor.of((String)"catalog1", (Configuration)new Configuration()));
    }

    private static /* synthetic */ void lambda$testStoreAndGet$0(CatalogStore catalogStore) throws Throwable {
        catalogStore.removeCatalog("catalog1", false);
    }
}

