/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph.util;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.graph.util.ImmutableStreamEdge;
import org.apache.flink.streaming.api.graph.util.ImmutableStreamGraph;
import org.apache.flink.streaming.api.graph.util.ImmutableStreamNode;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ImmutableStreamGraphTest {
    ImmutableStreamGraphTest() {
    }

    @Test
    void testImmutableStreamGraphGraphContent() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.fromSequence(1L, 3L).map((MapFunction & Serializable)value -> value).print().setParallelism(env.getParallelism());
        StreamGraph streamGraph = env.getStreamGraph();
        ImmutableStreamGraph immutableStreamGraph = new ImmutableStreamGraph(streamGraph, Thread.currentThread().getContextClassLoader());
        for (StreamNode streamNode : streamGraph.getStreamNodes()) {
            this.isStreamNodeEquals(streamNode, immutableStreamGraph.getStreamNode(Integer.valueOf(streamNode.getId())));
        }
    }

    void isStreamNodeEquals(StreamNode streamNode, ImmutableStreamNode immutableStreamNode) {
        Assertions.assertThat((Object)immutableStreamNode).isNotNull();
        Assertions.assertThat((int)streamNode.getId()).isEqualTo(immutableStreamNode.getId());
        Assertions.assertThat((int)streamNode.getInEdges().size()).isEqualTo(immutableStreamNode.getInEdges().size());
        Assertions.assertThat((int)streamNode.getOutEdges().size()).isEqualTo(immutableStreamNode.getOutEdges().size());
        List inEdges = streamNode.getInEdges();
        List immutableInEdges = immutableStreamNode.getInEdges();
        for (int i = 0; i < inEdges.size(); ++i) {
            this.isStreamEdgeEquals((StreamEdge)inEdges.get(i), (ImmutableStreamEdge)immutableInEdges.get(i));
        }
        List outEdges = streamNode.getOutEdges();
        List immutableOutEdges = immutableStreamNode.getOutEdges();
        for (int i = 0; i < outEdges.size(); ++i) {
            this.isStreamEdgeEquals((StreamEdge)outEdges.get(i), (ImmutableStreamEdge)immutableOutEdges.get(i));
        }
    }

    void isStreamEdgeEquals(StreamEdge streamEdge, ImmutableStreamEdge immutableStreamEdge) {
        Assertions.assertThat((Object)immutableStreamEdge).isNotNull();
        Assertions.assertThat((String)streamEdge.getEdgeId()).isEqualTo(immutableStreamEdge.getEdgeId());
        Assertions.assertThat((int)streamEdge.getSourceId()).isEqualTo(immutableStreamEdge.getSourceId());
        Assertions.assertThat((int)streamEdge.getTargetId()).isEqualTo(immutableStreamEdge.getTargetId());
        Assertions.assertThat((int)streamEdge.getTypeNumber()).isEqualTo(immutableStreamEdge.getTypeNumber());
    }
}

