/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import javax.annotation.Nonnull;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.triggers.AsyncTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.runtime.operators.windowing.AsyncTriggerConverter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsyncTriggerConverterTest {
    @Test
    void testTriggerUseDefaultConvert() {
        DummyTriggerWithoutAsyncConverter syncTrigger = new DummyTriggerWithoutAsyncConverter();
        AsyncTrigger asyncTrigger = AsyncTriggerConverter.convertToAsync((Trigger)syncTrigger);
        Assertions.assertThat((Object)asyncTrigger).isInstanceOf(AsyncTriggerConverter.UserDefinedAsyncTrigger.class);
        AsyncTriggerConverter.UserDefinedAsyncTrigger triggerWrapper = (AsyncTriggerConverter.UserDefinedAsyncTrigger)asyncTrigger;
        Assertions.assertThat((Object)triggerWrapper.getUserDefinedTrigger()).isSameAs((Object)syncTrigger);
    }

    @Test
    void testTriggerUseCustomizeConvert() {
        DummyTriggerWithAsyncConverter syncTrigger = new DummyTriggerWithAsyncConverter();
        AsyncTrigger asyncTrigger = AsyncTriggerConverter.convertToAsync((Trigger)syncTrigger);
        Assertions.assertThat((Object)asyncTrigger).isInstanceOf(DummyAsyncTrigger.class);
    }

    private static class DummyAsyncTrigger
    extends AsyncTrigger<Object, TimeWindow> {
        private DummyAsyncTrigger() {
        }

        public StateFuture<TriggerResult> onElement(Object element, long timestamp, TimeWindow window, AsyncTrigger.TriggerContext ctx) throws Exception {
            return null;
        }

        public StateFuture<TriggerResult> onProcessingTime(long time, TimeWindow window, AsyncTrigger.TriggerContext ctx) throws Exception {
            return null;
        }

        public StateFuture<TriggerResult> onEventTime(long time, TimeWindow window, AsyncTrigger.TriggerContext ctx) throws Exception {
            return null;
        }

        public StateFuture<Void> clear(TimeWindow window, AsyncTrigger.TriggerContext ctx) throws Exception {
            return null;
        }
    }

    private static class DummyTriggerWithAsyncConverter
    extends DummyTriggerWithoutAsyncConverter {
        private DummyTriggerWithAsyncConverter() {
        }

        @Nonnull
        public Object convertToAsync() {
            return new DummyAsyncTrigger();
        }
    }

    private static class DummyTriggerWithoutAsyncConverter
    extends Trigger<Object, TimeWindow>
    implements AsyncTriggerConverter {
        private DummyTriggerWithoutAsyncConverter() {
        }

        public TriggerResult onElement(Object element, long timestamp, TimeWindow window, Trigger.TriggerContext ctx) throws Exception {
            return null;
        }

        public TriggerResult onProcessingTime(long time, TimeWindow window, Trigger.TriggerContext ctx) throws Exception {
            return null;
        }

        public TriggerResult onEventTime(long time, TimeWindow window, Trigger.TriggerContext ctx) throws Exception {
            return null;
        }

        public void clear(TimeWindow window, Trigger.TriggerContext ctx) throws Exception {
        }
    }
}

