/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.BitSet;
import org.apache.flink.streaming.runtime.operators.windowing.KeyMap;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class KeyMapPutTest {
    KeyMapPutTest() {
    }

    @Test
    void testPutUniqueKeysAndGrowth() {
        int i;
        KeyMap map = new KeyMap();
        int numElements = 1000000;
        for (i = 0; i < 1000000; ++i) {
            map.put((Object)i, (Object)(2 * i + 1));
            Assertions.assertThat((int)map.size()).isEqualTo(i + 1).isLessThanOrEqualTo(map.getRehashThreshold());
            Assertions.assertThat((int)map.getCurrentTableCapacity()).isGreaterThan(map.size()).isGreaterThan(map.getRehashThreshold());
        }
        Assertions.assertThat((Iterable)map).hasSize(1000000);
        Assertions.assertThat((int)map.traverseAndCountElements()).isEqualTo(1000000);
        Assertions.assertThat((int)map.getCurrentTableCapacity()).isEqualTo(0x200000);
        for (i = 0; i < 1000000; ++i) {
            Assertions.assertThat((Integer)((Integer)map.get((Object)i))).isEqualTo(2 * i + 1);
        }
        for (i = 999999; i >= 0; --i) {
            Assertions.assertThat((Integer)((Integer)map.get((Object)i))).isEqualTo(2 * i + 1);
        }
        BitSet bitset = new BitSet();
        int numContained = 0;
        for (KeyMap.Entry entry : map) {
            ++numContained;
            Assertions.assertThat((Integer)((Integer)entry.getValue())).isEqualTo((Integer)entry.getKey() * 2 + 1);
            Assertions.assertThat((boolean)bitset.get((Integer)entry.getKey())).isFalse();
            bitset.set((Integer)entry.getKey());
        }
        Assertions.assertThat((int)numContained).isEqualTo(1000000);
        Assertions.assertThat((int)bitset.cardinality()).isEqualTo(1000000);
        Assertions.assertThat((Iterable)map).hasSize(1000000);
        Assertions.assertThat((int)map.traverseAndCountElements()).isEqualTo(1000000);
        Assertions.assertThat((int)map.getCurrentTableCapacity()).isEqualTo(0x200000);
        Assertions.assertThat((int)map.getLongestChainLength()).isLessThanOrEqualTo(7);
    }

    @Test
    void testPutDuplicateKeysAndGrowth() {
        Integer put;
        int i;
        KeyMap map = new KeyMap();
        int numElements = 1000000;
        for (i = 0; i < 1000000; ++i) {
            put = (Integer)map.put((Object)i, (Object)(2 * i + 1));
            Assertions.assertThat((Integer)put).isNull();
        }
        for (i = 0; i < 1000000; i += 3) {
            put = (Integer)map.put((Object)i, (Object)(2 * i));
            ((AbstractIntegerAssert)Assertions.assertThat((Integer)put).isNotNull()).isEqualTo(2 * i + 1);
        }
        for (i = 0; i < 1000000; ++i) {
            int expected = i % 3 == 0 ? 2 * i : 2 * i + 1;
            Assertions.assertThat((Integer)((Integer)map.get((Object)i))).isEqualTo(expected);
        }
        Assertions.assertThat((Iterable)map).hasSize(1000000);
        Assertions.assertThat((int)map.traverseAndCountElements()).isEqualTo(1000000);
        Assertions.assertThat((int)map.getCurrentTableCapacity()).isEqualTo(0x200000);
        Assertions.assertThat((int)map.getLongestChainLength()).isLessThanOrEqualTo(7);
        BitSet bitset = new BitSet();
        int numContained = 0;
        for (KeyMap.Entry entry : map) {
            ++numContained;
            int key = (Integer)entry.getKey();
            int expected = key % 3 == 0 ? 2 * key : 2 * key + 1;
            Assertions.assertThat((Integer)((Integer)entry.getValue())).isEqualTo(expected);
            Assertions.assertThat((boolean)bitset.get(key)).isFalse();
            bitset.set(key);
        }
        Assertions.assertThat((int)numContained).isEqualTo(1000000);
        Assertions.assertThat((int)bitset.cardinality()).isEqualTo(1000000);
    }
}

