/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.co;

import java.io.Serializable;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.streaming.api.functions.co.CoMapFunction;
import org.apache.flink.streaming.api.functions.co.RichCoMapFunction;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.operators.co.CoStreamMap;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.TestHarnessUtil;
import org.apache.flink.streaming.util.TwoInputStreamOperatorTestHarness;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CoStreamMapTest
implements Serializable {
    private static final long serialVersionUID = 1L;

    CoStreamMapTest() {
    }

    @Test
    void testCoMap() throws Exception {
        CoStreamMap operator = new CoStreamMap((CoMapFunction)new MyCoMap());
        TwoInputStreamOperatorTestHarness testHarness = new TwoInputStreamOperatorTestHarness((TwoInputStreamOperator)operator);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement1(new StreamRecord((Object)1.1, initialTime + 1L));
        testHarness.processElement1(new StreamRecord((Object)1.2, initialTime + 2L));
        testHarness.processElement1(new StreamRecord((Object)1.3, initialTime + 3L));
        testHarness.processWatermark1(new Watermark(initialTime + 3L));
        testHarness.processElement1(new StreamRecord((Object)1.4, initialTime + 4L));
        testHarness.processElement1(new StreamRecord((Object)1.5, initialTime + 5L));
        testHarness.processElement2(new StreamRecord((Object)1, initialTime + 1L));
        testHarness.processElement2(new StreamRecord((Object)2, initialTime + 2L));
        testHarness.processWatermark2(new Watermark(initialTime + 2L));
        testHarness.processElement2(new StreamRecord((Object)3, initialTime + 3L));
        testHarness.processElement2(new StreamRecord((Object)4, initialTime + 4L));
        testHarness.processElement2(new StreamRecord((Object)5, initialTime + 5L));
        expectedOutput.add(new StreamRecord((Object)"1.1", initialTime + 1L));
        expectedOutput.add(new StreamRecord((Object)"1.2", initialTime + 2L));
        expectedOutput.add(new StreamRecord((Object)"1.3", initialTime + 3L));
        expectedOutput.add(new StreamRecord((Object)"1.4", initialTime + 4L));
        expectedOutput.add(new StreamRecord((Object)"1.5", initialTime + 5L));
        expectedOutput.add(new StreamRecord((Object)"1", initialTime + 1L));
        expectedOutput.add(new StreamRecord((Object)"2", initialTime + 2L));
        expectedOutput.add(new Watermark(initialTime + 2L));
        expectedOutput.add(new StreamRecord((Object)"3", initialTime + 3L));
        expectedOutput.add(new StreamRecord((Object)"4", initialTime + 4L));
        expectedOutput.add(new StreamRecord((Object)"5", initialTime + 5L));
        TestHarnessUtil.assertOutputEquals((String)"Output was not correct.", expectedOutput, (Queue)testHarness.getOutput());
    }

    @Test
    void testOpenClose() throws Exception {
        CoStreamMap operator = new CoStreamMap((CoMapFunction)new TestOpenCloseCoMapFunction());
        TwoInputStreamOperatorTestHarness testHarness = new TwoInputStreamOperatorTestHarness((TwoInputStreamOperator)operator);
        long initialTime = 0L;
        testHarness.open();
        testHarness.processElement1(new StreamRecord((Object)74.0, initialTime));
        testHarness.processElement2(new StreamRecord((Object)42, initialTime));
        testHarness.close();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)TestOpenCloseCoMapFunction.closeCalled).as("RichFunction methods where not called.", new Object[0])).isTrue();
        Assertions.assertThat((Collection)testHarness.getOutput()).isNotEmpty();
    }

    private static class TestOpenCloseCoMapFunction
    extends RichCoMapFunction<Double, Integer, String> {
        private static final long serialVersionUID = 1L;
        public static boolean openCalled = false;
        public static boolean closeCalled = false;

        private TestOpenCloseCoMapFunction() {
        }

        public void open(OpenContext openContext) throws Exception {
            super.open(openContext);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)closeCalled).as("Close was called before open.", new Object[0])).isFalse();
            openCalled = true;
        }

        public void close() throws Exception {
            super.close();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)openCalled).as("Open was not called before close.", new Object[0])).isTrue();
            closeCalled = true;
        }

        public String map1(Double value) throws Exception {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)openCalled).as("Open was not called before run.", new Object[0])).isTrue();
            return value.toString();
        }

        public String map2(Integer value) throws Exception {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)openCalled).as("Open was not called before run.", new Object[0])).isTrue();
            return value.toString();
        }
    }

    private static final class MyCoMap
    implements CoMapFunction<Double, Integer, String> {
        private static final long serialVersionUID = 1L;

        private MyCoMap() {
        }

        public String map1(Double value) {
            return value.toString();
        }

        public String map2(Integer value) {
            return value.toString();
        }
    }
}

