/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb.restore;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.IncrementalLocalKeyedStateHandle;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.state.rocksdb.RocksDBOperationUtils;
import org.apache.flink.state.rocksdb.ttl.RocksDbTtlCompactFiltersManager;
import org.apache.flink.util.IOUtils;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;

public class RestoredDBInstance
implements AutoCloseable {
    @Nonnull
    public final RocksDB db;
    @Nonnull
    public final ColumnFamilyHandle defaultColumnFamilyHandle;
    @Nonnull
    public final List<ColumnFamilyHandle> columnFamilyHandles;
    @Nonnull
    public final List<ColumnFamilyDescriptor> columnFamilyDescriptors;
    @Nonnull
    public final List<StateMetaInfoSnapshot> stateMetaInfoSnapshots;
    public final ReadOptions readOptions;
    public final IncrementalLocalKeyedStateHandle srcStateHandle;

    public RestoredDBInstance(@Nonnull RocksDB db, @Nonnull List<ColumnFamilyHandle> columnFamilyHandles, @Nonnull List<ColumnFamilyDescriptor> columnFamilyDescriptors, @Nonnull List<StateMetaInfoSnapshot> stateMetaInfoSnapshots, IncrementalLocalKeyedStateHandle srcStateHandle) {
        this.db = db;
        this.defaultColumnFamilyHandle = columnFamilyHandles.remove(0);
        this.columnFamilyHandles = columnFamilyHandles;
        this.columnFamilyDescriptors = columnFamilyDescriptors;
        this.stateMetaInfoSnapshots = stateMetaInfoSnapshots;
        this.readOptions = new ReadOptions();
        this.srcStateHandle = srcStateHandle;
    }

    @Override
    public void close() {
        ArrayList<ColumnFamilyOptions> columnFamilyOptions = new ArrayList<ColumnFamilyOptions>(this.columnFamilyDescriptors.size() + 1);
        this.columnFamilyDescriptors.forEach(cfd -> columnFamilyOptions.add(cfd.getOptions()));
        RocksDBOperationUtils.addColumnFamilyOptionsToCloseLater(columnFamilyOptions, this.defaultColumnFamilyHandle);
        IOUtils.closeQuietly((AutoCloseable)this.defaultColumnFamilyHandle);
        IOUtils.closeAllQuietly(this.columnFamilyHandles);
        IOUtils.closeQuietly((AutoCloseable)this.db);
        IOUtils.closeAllQuietly(columnFamilyOptions);
        IOUtils.closeQuietly((AutoCloseable)this.readOptions);
    }

    public static RestoredDBInstance restoreTempDBInstanceFromLocalState(IncrementalLocalKeyedStateHandle stateHandle, List<StateMetaInfoSnapshot> stateMetaInfoSnapshots, Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory, DBOptions dbOptions, RocksDbTtlCompactFiltersManager ttlCompactFiltersManager, Long writeBufferManagerCapacity) throws Exception {
        Function<String, ColumnFamilyOptions> tempDBCfFactory = stateName -> ((ColumnFamilyOptions)columnFamilyOptionsFactory.apply((String)stateName)).setDisableAutoCompactions(true);
        List<ColumnFamilyDescriptor> columnFamilyDescriptors = RestoredDBInstance.createColumnFamilyDescriptors(stateMetaInfoSnapshots, tempDBCfFactory, ttlCompactFiltersManager, writeBufferManagerCapacity, false);
        Path restoreSourcePath = stateHandle.getDirectoryStateHandle().getDirectory();
        ArrayList<ColumnFamilyHandle> columnFamilyHandles = new ArrayList<ColumnFamilyHandle>(stateMetaInfoSnapshots.size() + 1);
        RocksDB db = RocksDBOperationUtils.openDB(restoreSourcePath.toString(), columnFamilyDescriptors, columnFamilyHandles, RocksDBOperationUtils.createColumnFamilyOptions(tempDBCfFactory, "default"), dbOptions);
        return new RestoredDBInstance(db, columnFamilyHandles, columnFamilyDescriptors, stateMetaInfoSnapshots, stateHandle);
    }

    public static List<ColumnFamilyDescriptor> createColumnFamilyDescriptors(List<StateMetaInfoSnapshot> stateMetaInfoSnapshots, Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory, RocksDbTtlCompactFiltersManager ttlCompactFiltersManager, Long writeBufferManagerCapacity, boolean registerTtlCompactFilter) {
        ArrayList<ColumnFamilyDescriptor> columnFamilyDescriptors = new ArrayList<ColumnFamilyDescriptor>(stateMetaInfoSnapshots.size());
        for (StateMetaInfoSnapshot stateMetaInfoSnapshot : stateMetaInfoSnapshots) {
            RegisteredStateMetaInfoBase metaInfoBase = RegisteredStateMetaInfoBase.fromMetaInfoSnapshot((StateMetaInfoSnapshot)stateMetaInfoSnapshot);
            ColumnFamilyDescriptor columnFamilyDescriptor = RocksDBOperationUtils.createColumnFamilyDescriptor(metaInfoBase, columnFamilyOptionsFactory, registerTtlCompactFilter ? ttlCompactFiltersManager : null, writeBufferManagerCapacity);
            columnFamilyDescriptors.add(columnFamilyDescriptor);
        }
        return columnFamilyDescriptors;
    }
}

