/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb.iterator;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.runtime.state.CompositeKeySerializationUtils;
import org.apache.flink.state.rocksdb.RocksIteratorWrapper;

@Internal
public abstract class AbstractRocksStateKeysIterator<K>
implements AutoCloseable {
    @Nonnull
    protected final RocksIteratorWrapper iterator;
    @Nonnull
    protected final String state;
    @Nonnull
    protected final TypeSerializer<K> keySerializer;
    protected final boolean ambiguousKeyPossible;
    protected final int keyGroupPrefixBytes;
    protected final DataInputDeserializer byteArrayDataInputView;

    public AbstractRocksStateKeysIterator(@Nonnull RocksIteratorWrapper iterator, @Nonnull String state, @Nonnull TypeSerializer<K> keySerializer, int keyGroupPrefixBytes, boolean ambiguousKeyPossible) {
        this.iterator = iterator;
        this.state = state;
        this.keySerializer = keySerializer;
        this.keyGroupPrefixBytes = keyGroupPrefixBytes;
        this.ambiguousKeyPossible = ambiguousKeyPossible;
        this.byteArrayDataInputView = new DataInputDeserializer();
    }

    protected K deserializeKey(byte[] keyBytes, DataInputDeserializer readView) throws IOException {
        readView.setBuffer(keyBytes, this.keyGroupPrefixBytes, keyBytes.length - this.keyGroupPrefixBytes);
        return (K)CompositeKeySerializationUtils.readKey(this.keySerializer, (DataInputDeserializer)this.byteArrayDataInputView, (boolean)this.ambiguousKeyPossible);
    }

    @Override
    public void close() {
        this.iterator.close();
    }

    public static boolean isMatchingNameSpace(@Nonnull byte[] key, int namespaceBytesStartPos, @Nonnull byte[] namespaceBytes) {
        if (key.length >= namespaceBytesStartPos + namespaceBytes.length) {
            for (int i = 0; i < namespaceBytes.length; ++i) {
                if (key[namespaceBytesStartPos + i] == namespaceBytes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

