/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

public final class ListDelimitedSerializer {
    private static final byte DELIMITER = 44;

    private ListDelimitedSerializer() {
    }

    public static <T> List<T> deserializeList(byte[] valueBytes, TypeSerializer<T> elementSerializer, DataInputDeserializer dataInputView) throws IOException {
        T next;
        if (valueBytes == null) {
            return null;
        }
        dataInputView.setBuffer(valueBytes);
        ArrayList<T> result = new ArrayList<T>();
        while ((next = ListDelimitedSerializer.deserializeNextElement(dataInputView, elementSerializer)) != null) {
            result.add(next);
        }
        return result;
    }

    public static <T> byte[] serializeList(List<T> valueList, TypeSerializer<T> elementSerializer, DataOutputSerializer dataOutputView) throws IOException {
        dataOutputView.clear();
        boolean first = true;
        for (T value : valueList) {
            Preconditions.checkNotNull(value, (String)"You cannot add null to a value list.");
            if (first) {
                first = false;
            } else {
                dataOutputView.write(44);
            }
            elementSerializer.serialize(value, (DataOutputView)dataOutputView);
        }
        return dataOutputView.getCopyOfBuffer();
    }

    public static <T> T deserializeNextElement(DataInputDeserializer in, TypeSerializer<T> elementSerializer) throws IOException {
        if (in.available() > 0) {
            Object element = elementSerializer.deserialize((DataInputView)in);
            if (in.available() > 0) {
                in.readByte();
            }
            return (T)element;
        }
        return null;
    }
}

