/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.RecoveryClaimMode;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.memory.OpaqueMemoryResource;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.state.forst.ForStConfigurableOptions;
import org.apache.flink.state.forst.ForStNativeMetricOptions;
import org.apache.flink.state.forst.ForStOptions;
import org.apache.flink.state.forst.ForStOptionsFactory;
import org.apache.flink.state.forst.ForStPathContainer;
import org.apache.flink.state.forst.ForStSharedResources;
import org.apache.flink.state.forst.fs.ForStFlinkFileSystem;
import org.apache.flink.state.forst.fs.StringifiedForStFileSystem;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.forstdb.BlockBasedTableConfig;
import org.forstdb.BloomFilter;
import org.forstdb.Cache;
import org.forstdb.ColumnFamilyOptions;
import org.forstdb.DBOptions;
import org.forstdb.Env;
import org.forstdb.Filter;
import org.forstdb.FlinkEnv;
import org.forstdb.IndexType;
import org.forstdb.PlainTableConfig;
import org.forstdb.ReadOptions;
import org.forstdb.Statistics;
import org.forstdb.TableFormatConfig;
import org.forstdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ForStResourceContainer
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ForStResourceContainer.class);
    private static final String FORST_RELOCATE_LOG_SUFFIX = "_LOG";
    private static final int INSTANCE_PATH_LENGTH_LIMIT = 255 - "_LOG".length();
    private final ForStPathContainer pathContainer;
    private boolean remotePathNewlyCreated;
    @Nullable
    private Path cacheBasePath;
    private final long cacheCapacity;
    private final long cacheReservedSize;
    private final ReadableConfig configuration;
    @Nullable
    private final ForStOptionsFactory optionsFactory;
    @Nullable
    private ForStFlinkFileSystem forStFileSystem;
    @Nullable
    private final OpaqueMemoryResource<ForStSharedResources> sharedResources;
    private final boolean enableStatistics;
    private final ArrayList<AutoCloseable> handlesToClose;
    @Nullable
    private java.nio.file.Path relocatedDbLogBaseDir;
    @Nullable
    private final MetricGroup metricGroup;

    @VisibleForTesting
    public ForStResourceContainer() {
        this((ReadableConfig)new Configuration(), null, null, ForStPathContainer.empty(), RecoveryClaimMode.DEFAULT, null, null, false);
    }

    @VisibleForTesting
    public ForStResourceContainer(@Nullable ForStOptionsFactory optionsFactory) {
        this((ReadableConfig)new Configuration(), optionsFactory, null, ForStPathContainer.empty(), RecoveryClaimMode.DEFAULT, null, null, false);
    }

    @VisibleForTesting
    public ForStResourceContainer(@Nullable ForStOptionsFactory optionsFactory, @Nullable OpaqueMemoryResource<ForStSharedResources> sharedResources) {
        this((ReadableConfig)new Configuration(), optionsFactory, sharedResources, ForStPathContainer.empty(), RecoveryClaimMode.DEFAULT, null, null, false);
    }

    public ForStResourceContainer(ReadableConfig configuration, @Nullable ForStOptionsFactory optionsFactory, @Nullable OpaqueMemoryResource<ForStSharedResources> sharedResources, ForStPathContainer pathContainer, RecoveryClaimMode claimMode, @Nullable CheckpointStorageAccess checkpointStorageAccess, MetricGroup metricGroup, boolean enableStatistics) {
        this.configuration = configuration;
        this.optionsFactory = optionsFactory;
        this.sharedResources = sharedResources;
        this.pathContainer = pathContainer;
        this.enableStatistics = enableStatistics;
        this.handlesToClose = new ArrayList();
        this.cacheBasePath = configuration.getOptional(ForStOptions.CACHE_DIRECTORY).map(Path::new).orElse(null);
        this.cacheCapacity = ((MemorySize)configuration.get(ForStOptions.CACHE_SIZE_BASE_LIMIT)).getBytes();
        this.cacheReservedSize = ((MemorySize)configuration.get(ForStOptions.CACHE_RESERVED_SIZE)).getBytes();
        this.metricGroup = metricGroup;
    }

    public DBOptions getDbOptions() {
        DBOptions opt = this.createBaseCommonDBOptions();
        this.handlesToClose.add((AutoCloseable)opt);
        this.setDBOptionsFromConfigurableOptions(opt);
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createDBOptions(opt, this.handlesToClose);
        }
        opt = opt.setCreateIfMissing(true).setAvoidFlushDuringShutdown(true);
        if (this.sharedResources != null) {
            opt.setWriteBufferManager(((ForStSharedResources)this.sharedResources.getResourceHandle()).getWriteBufferManager());
        }
        if (this.enableStatistics) {
            Statistics statistics = new Statistics();
            opt.setStatistics(statistics);
            this.handlesToClose.add((AutoCloseable)statistics);
        }
        if (this.pathContainer.getRemoteForStPath() != null) {
            FlinkEnv flinkEnv = new FlinkEnv(this.pathContainer.getRemoteBasePath().toString(), (Object)new StringifiedForStFileSystem(this.forStFileSystem));
            opt.setEnv((Env)flinkEnv);
            this.handlesToClose.add((AutoCloseable)flinkEnv);
        }
        return opt;
    }

    public ColumnFamilyOptions getColumnOptions() {
        ColumnFamilyOptions opt = this.createBaseCommonColumnOptions();
        this.handlesToClose.add((AutoCloseable)opt);
        this.setColumnFamilyOptionsFromConfigurableOptions(opt, this.handlesToClose);
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createColumnOptions(opt, this.handlesToClose);
        }
        if (this.sharedResources != null) {
            BlockBasedTableConfig blockBasedTableConfig;
            ForStSharedResources rocksResources = (ForStSharedResources)this.sharedResources.getResourceHandle();
            Cache blockCache = rocksResources.getCache();
            TableFormatConfig tableFormatConfig = opt.tableFormatConfig();
            if (tableFormatConfig == null) {
                blockBasedTableConfig = new BlockBasedTableConfig();
            } else {
                Preconditions.checkArgument((boolean)(tableFormatConfig instanceof BlockBasedTableConfig), (Object)"We currently only support BlockBasedTableConfig When bounding total memory.");
                blockBasedTableConfig = (BlockBasedTableConfig)tableFormatConfig;
            }
            if (rocksResources.isUsingPartitionedIndexFilters() && this.overwriteFilterIfExist(blockBasedTableConfig)) {
                blockBasedTableConfig.setIndexType(IndexType.kTwoLevelIndexSearch);
                blockBasedTableConfig.setPartitionFilters(true);
                blockBasedTableConfig.setPinTopLevelIndexAndFilter(true);
            }
            blockBasedTableConfig.setBlockCache(blockCache);
            blockBasedTableConfig.setCacheIndexAndFilterBlocks(true);
            blockBasedTableConfig.setCacheIndexAndFilterBlocksWithHighPriority(true);
            blockBasedTableConfig.setPinL0FilterAndIndexBlocksInCache(true);
            opt.setTableFormatConfig((TableFormatConfig)blockBasedTableConfig);
        }
        return opt;
    }

    public WriteOptions getWriteOptions() {
        WriteOptions opt = new WriteOptions().setDisableWAL(true);
        this.handlesToClose.add((AutoCloseable)opt);
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createWriteOptions(opt, this.handlesToClose);
        }
        return opt;
    }

    public ReadOptions getReadOptions() {
        ReadOptions opt = new ReadOptions();
        this.handlesToClose.add((AutoCloseable)opt);
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createReadOptions(opt, this.handlesToClose);
        }
        return opt;
    }

    public ForStPathContainer getPathContainer() {
        return this.pathContainer;
    }

    public Path getBasePath() {
        return this.pathContainer.getBasePath();
    }

    public Path getDbPath() {
        return this.pathContainer.getDbPath();
    }

    public boolean isCoordinatorInline() {
        return (Boolean)this.configuration.get(ForStOptions.EXECUTOR_COORDINATOR_INLINE);
    }

    public boolean isWriteInline() {
        return (Boolean)this.configuration.get(ForStOptions.EXECUTOR_WRITE_IO_INLINE);
    }

    public int getReadIoParallelism() {
        return (Integer)this.configuration.get(ForStOptions.EXECUTOR_READ_IO_PARALLELISM);
    }

    public int getWriteIoParallelism() {
        return (Integer)this.configuration.get(ForStOptions.EXECUTOR_WRITE_IO_PARALLELISM);
    }

    public void prepareDirectories() throws Exception {
        if (this.pathContainer.getRemoteBasePath() != null && this.pathContainer.getRemoteForStPath() != null) {
            this.remotePathNewlyCreated = ForStResourceContainer.prepareDirectories(this.pathContainer.getRemoteBasePath(), this.pathContainer.getRemoteForStPath());
        }
        if (this.pathContainer.getLocalBasePath() != null && this.pathContainer.getLocalForStPath() != null) {
            ForStResourceContainer.prepareDirectories(this.pathContainer.getLocalBasePath(), this.pathContainer.getLocalForStPath());
        }
        if (this.pathContainer.getRemoteForStPath() != null && this.pathContainer.getLocalForStPath() != null) {
            if (this.cacheBasePath == null && this.pathContainer.getLocalBasePath() != null) {
                this.cacheBasePath = new Path(this.pathContainer.getLocalBasePath().getPath(), "cache");
                LOG.info("Cache base path is not configured, set to local base path: {}", (Object)this.cacheBasePath);
            }
            this.forStFileSystem = ForStFlinkFileSystem.get(this.pathContainer.getRemoteForStPath().toUri(), this.pathContainer.getLocalForStPath(), ForStFlinkFileSystem.getFileBasedCache(this.configuration, this.cacheBasePath, this.pathContainer.getRemoteForStPath(), this.cacheCapacity, this.cacheReservedSize, this.metricGroup));
        } else {
            this.forStFileSystem = null;
        }
    }

    @Nullable
    public ForStFlinkFileSystem getFileSystem() {
        return this.forStFileSystem;
    }

    private static boolean prepareDirectories(Path basePath, Path dbPath) throws IOException {
        boolean allNewlyCreated = true;
        FileSystem fileSystem = basePath.getFileSystem();
        if (fileSystem.exists(basePath)) {
            if (!fileSystem.getFileStatus(basePath).isDir()) {
                throw new IOException("Not a directory: " + basePath);
            }
            allNewlyCreated = false;
        } else if (!fileSystem.mkdirs(basePath)) {
            throw new IOException(String.format("Could not create ForSt directory at %s.", basePath));
        }
        if (fileSystem.exists(dbPath)) {
            LOG.info("Reusing previous ForSt db directory at {}.", (Object)dbPath);
            allNewlyCreated = false;
        } else if (!fileSystem.mkdirs(dbPath)) {
            throw new IOException(String.format("Could not create ForSt db directory at %s.", dbPath));
        }
        return allNewlyCreated;
    }

    public void clearDirectories() throws Exception {
        Path localBasePath;
        Path remoteBasePath = this.pathContainer.getRemoteBasePath();
        if (remoteBasePath != null) {
            this.forStFileSystem.delete(remoteBasePath, true);
        }
        if ((localBasePath = this.pathContainer.getLocalBasePath()) != null) {
            ForStResourceContainer.clearDirectories(localBasePath);
        }
    }

    public void forceClearRemoteDirectories() throws Exception {
        if (this.pathContainer.getRemoteBasePath() != null && this.remotePathNewlyCreated) {
            ForStResourceContainer.clearDirectories(this.pathContainer.getRemoteBasePath());
        }
    }

    private static void clearDirectories(Path basePath) throws IOException {
        FileSystem fileSystem = basePath.getFileSystem();
        if (fileSystem.exists(basePath)) {
            fileSystem.delete(basePath, true);
        }
    }

    ForStNativeMetricOptions getMemoryWatcherOptions(ForStNativeMetricOptions defaultMetricOptions) {
        return this.optionsFactory == null ? defaultMetricOptions : this.optionsFactory.createNativeMetricsOptions(defaultMetricOptions);
    }

    @Override
    public void close() throws Exception {
        this.handlesToClose.forEach(IOUtils::closeQuietly);
        this.handlesToClose.clear();
        if (this.sharedResources != null) {
            this.sharedResources.close();
        }
        this.cleanRelocatedDbLogs();
        if (this.forStFileSystem != null) {
            this.forStFileSystem.close();
        }
    }

    private boolean overwriteFilterIfExist(BlockBasedTableConfig blockBasedTableConfig) {
        if (blockBasedTableConfig.filterPolicy() != null) {
            BloomFilter newFilter = new BloomFilter(10.0, false);
            LOG.info("Existing filter has been overwritten to full filters since partitioned index filters is enabled.");
            blockBasedTableConfig.setFilterPolicy((Filter)newFilter);
            this.handlesToClose.add((AutoCloseable)newFilter);
        }
        return true;
    }

    DBOptions createBaseCommonDBOptions() {
        return new DBOptions().setUseFsync(false).setStatsDumpPeriodSec(0);
    }

    ColumnFamilyOptions createBaseCommonColumnOptions() {
        return new ColumnFamilyOptions();
    }

    @Nullable
    private <T> T internalGetOption(ConfigOption<T> option) {
        return (T)this.configuration.getOptional(option).orElseGet(() -> option.defaultValue());
    }

    private DBOptions setDBOptionsFromConfigurableOptions(DBOptions currentOptions) {
        currentOptions.setMaxBackgroundJobs(this.internalGetOption(ForStConfigurableOptions.MAX_BACKGROUND_THREADS).intValue());
        currentOptions.setMaxOpenFiles(this.internalGetOption(ForStConfigurableOptions.MAX_OPEN_FILES).intValue());
        currentOptions.setInfoLogLevel(this.internalGetOption(ForStConfigurableOptions.LOG_LEVEL));
        String logDir = this.internalGetOption(ForStConfigurableOptions.LOG_DIR);
        if (logDir == null || logDir.isEmpty()) {
            if (this.pathContainer.getRemoteForStPath() == null && this.pathContainer.getLocalForStPath() != null && this.pathContainer.getLocalForStPath().getPath().length() <= INSTANCE_PATH_LENGTH_LIMIT) {
                this.relocateDefaultDbLogDir(currentOptions);
            }
        } else {
            currentOptions.setDbLogDir(logDir);
        }
        currentOptions.setMaxLogFileSize(this.internalGetOption(ForStConfigurableOptions.LOG_MAX_FILE_SIZE).getBytes());
        currentOptions.setKeepLogFileNum((long)this.internalGetOption(ForStConfigurableOptions.LOG_FILE_NUM).intValue());
        return currentOptions;
    }

    private ColumnFamilyOptions setColumnFamilyOptionsFromConfigurableOptions(ColumnFamilyOptions currentOptions, Collection<AutoCloseable> handlesToClose) {
        BlockBasedTableConfig blockBasedTableConfig;
        currentOptions.setCompactionStyle(this.internalGetOption(ForStConfigurableOptions.COMPACTION_STYLE));
        currentOptions.setCompressionPerLevel(this.internalGetOption(ForStConfigurableOptions.COMPRESSION_PER_LEVEL));
        currentOptions.setLevelCompactionDynamicLevelBytes(this.internalGetOption(ForStConfigurableOptions.USE_DYNAMIC_LEVEL_SIZE).booleanValue());
        currentOptions.setTargetFileSizeBase(this.internalGetOption(ForStConfigurableOptions.TARGET_FILE_SIZE_BASE).getBytes());
        currentOptions.setMaxBytesForLevelBase(this.internalGetOption(ForStConfigurableOptions.MAX_SIZE_LEVEL_BASE).getBytes());
        currentOptions.setWriteBufferSize(this.internalGetOption(ForStConfigurableOptions.WRITE_BUFFER_SIZE).getBytes());
        currentOptions.setMaxWriteBufferNumber(this.internalGetOption(ForStConfigurableOptions.MAX_WRITE_BUFFER_NUMBER).intValue());
        currentOptions.setMinWriteBufferNumberToMerge(this.internalGetOption(ForStConfigurableOptions.MIN_WRITE_BUFFER_NUMBER_TO_MERGE).intValue());
        currentOptions.setPeriodicCompactionSeconds(this.internalGetOption(ForStConfigurableOptions.COMPACT_FILTER_PERIODIC_COMPACTION_TIME).getSeconds());
        TableFormatConfig tableFormatConfig = currentOptions.tableFormatConfig();
        if (tableFormatConfig == null) {
            blockBasedTableConfig = new BlockBasedTableConfig();
        } else {
            if (tableFormatConfig instanceof PlainTableConfig) {
                return currentOptions;
            }
            blockBasedTableConfig = (BlockBasedTableConfig)tableFormatConfig;
        }
        blockBasedTableConfig.setBlockSize(this.internalGetOption(ForStConfigurableOptions.BLOCK_SIZE).getBytes());
        blockBasedTableConfig.setMetadataBlockSize(this.internalGetOption(ForStConfigurableOptions.METADATA_BLOCK_SIZE).getBytes());
        blockBasedTableConfig.setBlockCacheSize(this.internalGetOption(ForStConfigurableOptions.BLOCK_CACHE_SIZE).getBytes());
        if (this.internalGetOption(ForStConfigurableOptions.USE_BLOOM_FILTER).booleanValue()) {
            double bitsPerKey = this.internalGetOption(ForStConfigurableOptions.BLOOM_FILTER_BITS_PER_KEY);
            boolean blockBasedMode = this.internalGetOption(ForStConfigurableOptions.BLOOM_FILTER_BLOCK_BASED_MODE);
            BloomFilter bloomFilter = new BloomFilter(bitsPerKey, blockBasedMode);
            handlesToClose.add((AutoCloseable)bloomFilter);
            blockBasedTableConfig.setFilterPolicy((Filter)bloomFilter);
        }
        return currentOptions.setTableFormatConfig((TableFormatConfig)blockBasedTableConfig);
    }

    private void relocateDefaultDbLogDir(DBOptions dbOptions) {
        String logFilePath = System.getProperty("log.file");
        if (logFilePath != null) {
            File logFile = this.resolveFileLocation(logFilePath);
            if (logFile != null && this.resolveFileLocation(logFile.getParent()) != null) {
                String relocatedDbLogDir = logFile.getParent();
                this.relocatedDbLogBaseDir = new File(relocatedDbLogDir).toPath();
                dbOptions.setDbLogDir(relocatedDbLogDir);
            } else {
                this.setLocalForStPathAsLogDir(dbOptions);
            }
        } else {
            this.setLocalForStPathAsLogDir(dbOptions);
        }
    }

    private void setLocalForStPathAsLogDir(DBOptions dbOptions) {
        if (this.pathContainer.getLocalForStPath() != null) {
            this.relocatedDbLogBaseDir = java.nio.file.Path.of(this.pathContainer.getLocalForStPath().toUri().toString(), new String[0]);
            dbOptions.setDbLogDir(this.pathContainer.getLocalForStPath().getPath());
        }
    }

    private File resolveFileLocation(String logFilePath) {
        File logFile = new File(logFilePath);
        return logFile.exists() && logFile.canRead() ? logFile : null;
    }

    private void cleanRelocatedDbLogs() {
        if (this.pathContainer.getLocalForStPath() != null && this.relocatedDbLogBaseDir != null) {
            LOG.info("Cleaning up relocated ForSt logs: {}.", (Object)this.relocatedDbLogBaseDir);
            String relocatedDbLogPrefix = this.resolveRelocatedDbLogPrefix(this.pathContainer.getLocalForStPath().getPath());
            try {
                Arrays.stream(FileUtils.listDirectory((java.nio.file.Path)this.relocatedDbLogBaseDir)).filter(path -> !Files.isDirectory(path, new LinkOption[0]) && path.toFile().getName().startsWith(relocatedDbLogPrefix)).forEach(IOUtils::deleteFileQuietly);
            }
            catch (IOException e) {
                LOG.warn("Could not list relocated ForSt log directory: {}", (Object)this.relocatedDbLogBaseDir);
            }
        }
    }

    private String resolveRelocatedDbLogPrefix(String instanceForStAbsolutePath) {
        if (!instanceForStAbsolutePath.isEmpty() && !instanceForStAbsolutePath.matches("^[a-zA-Z0-9\\-._].*")) {
            instanceForStAbsolutePath = instanceForStAbsolutePath.substring(1);
        }
        return instanceForStAbsolutePath.replaceAll("[^a-zA-Z0-9\\-._]", "_") + FORST_RELOCATE_LOG_SUFFIX;
    }

    public Long getWriteBufferManagerCapacity() {
        if (this.sharedResources == null) {
            return null;
        }
        return ((ForStSharedResources)this.sharedResources.getResourceHandle()).getWriteBufferManagerCapacity();
    }

    public Long getQueryTimeAfterNumEntries() {
        return this.internalGetOption(ForStConfigurableOptions.COMPACT_FILTER_QUERY_TIME_AFTER_NUM_ENTRIES);
    }

    public Duration getPeriodicCompactionTime() {
        return this.internalGetOption(ForStConfigurableOptions.COMPACT_FILTER_PERIODIC_COMPACTION_TIME);
    }
}

