/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.api.common.state.v2.MapState;
import org.apache.flink.api.common.state.v2.State;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.asyncprocessing.InternalAsyncFuture;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.asyncprocessing.StateRequest;
import org.apache.flink.runtime.asyncprocessing.StateRequestHandler;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.runtime.state.SerializedCompositeKeyBuilder;
import org.apache.flink.runtime.state.v2.AbstractMapState;
import org.apache.flink.state.forst.ContextKey;
import org.apache.flink.state.forst.ForStDBBunchPutRequest;
import org.apache.flink.state.forst.ForStDBGetRequest;
import org.apache.flink.state.forst.ForStDBIterRequest;
import org.apache.flink.state.forst.ForStDBMapCheckRequest;
import org.apache.flink.state.forst.ForStDBMapEntryIterRequest;
import org.apache.flink.state.forst.ForStDBMapKeyIterRequest;
import org.apache.flink.state.forst.ForStDBMapValueIterRequest;
import org.apache.flink.state.forst.ForStDBPutRequest;
import org.apache.flink.state.forst.ForStDBSingleGetRequest;
import org.apache.flink.state.forst.ForStInnerTable;
import org.apache.flink.util.Preconditions;
import org.forstdb.ColumnFamilyHandle;
import org.forstdb.RocksIterator;

public class ForStMapState<K, N, UK, UV>
extends AbstractMapState<K, N, UK, UV>
implements MapState<UK, UV>,
ForStInnerTable<K, N, UV> {
    private final ColumnFamilyHandle columnFamilyHandle;
    private final ThreadLocal<SerializedCompositeKeyBuilder<K>> serializedKeyBuilder;
    private final N defaultNamespace;
    private final ThreadLocal<TypeSerializer<N>> namespaceSerializer;
    final ThreadLocal<DataOutputSerializer> valueSerializerView;
    final ThreadLocal<DataInputDeserializer> keyDeserializerView;
    final ThreadLocal<DataInputDeserializer> valueDeserializerView;
    final ThreadLocal<TypeSerializer<UK>> userKeySerializer;
    final ThreadLocal<TypeSerializer<UV>> userValueSerializer;
    private final int keyGroupPrefixBytes;

    public ForStMapState(StateRequestHandler stateRequestHandler, ColumnFamilyHandle columnFamily, TypeSerializer<UK> userKeySerializer, TypeSerializer<UV> valueSerializer, Supplier<SerializedCompositeKeyBuilder<K>> serializedKeyBuilderInitializer, N defaultNamespace, Supplier<TypeSerializer<N>> namespaceSerializerInitializer, Supplier<DataOutputSerializer> valueSerializerViewInitializer, Supplier<DataInputDeserializer> keyDeserializerViewInitializer, Supplier<DataInputDeserializer> valueDeserializerViewInitializer, int keyGroupPrefixBytes) {
        super(stateRequestHandler, valueSerializer);
        this.columnFamilyHandle = columnFamily;
        this.serializedKeyBuilder = ThreadLocal.withInitial(serializedKeyBuilderInitializer);
        this.defaultNamespace = defaultNamespace;
        this.namespaceSerializer = ThreadLocal.withInitial(namespaceSerializerInitializer);
        this.valueSerializerView = ThreadLocal.withInitial(valueSerializerViewInitializer);
        this.keyDeserializerView = ThreadLocal.withInitial(keyDeserializerViewInitializer);
        this.valueDeserializerView = ThreadLocal.withInitial(valueDeserializerViewInitializer);
        this.userKeySerializer = ThreadLocal.withInitial(() -> userKeySerializer.duplicate());
        this.userValueSerializer = ThreadLocal.withInitial(() -> valueSerializer.duplicate());
        this.keyGroupPrefixBytes = keyGroupPrefixBytes;
    }

    public int getKeyGroupPrefixBytes() {
        return this.keyGroupPrefixBytes;
    }

    @Override
    public ColumnFamilyHandle getColumnFamilyHandle() {
        return this.columnFamilyHandle;
    }

    @Override
    public byte[] serializeKey(ContextKey<K, N> contextKey) throws IOException {
        SerializedCompositeKeyBuilder<K> builder = this.serializedKeyBuilder.get();
        builder.setKeyAndKeyGroup(contextKey.getRawKey(), contextKey.getKeyGroup());
        N namespace = contextKey.getNamespace();
        builder.setNamespace(namespace == null ? this.defaultNamespace : namespace, this.namespaceSerializer.get());
        if (contextKey.getUserKey() == null) {
            return builder.build();
        }
        Object userKey = contextKey.getUserKey();
        return builder.buildCompositeKeyUserKey(userKey, this.userKeySerializer.get());
    }

    @Override
    public byte[] serializeValue(UV value) throws IOException {
        DataOutputSerializer outputView = this.valueSerializerView.get();
        outputView.clear();
        outputView.writeBoolean(false);
        this.userValueSerializer.get().serialize(value, (DataOutputView)outputView);
        return outputView.getCopyOfBuffer();
    }

    @Override
    public UV deserializeValue(byte[] valueBytes) throws IOException {
        DataInputDeserializer inputView = this.valueDeserializerView.get();
        inputView.setBuffer(valueBytes);
        boolean isNull = inputView.readBoolean();
        return (UV)(isNull ? null : this.userValueSerializer.get().deserialize((DataInputView)inputView));
    }

    public UK deserializeUserKey(byte[] userKeyBytes, int userKeyOffset) throws IOException {
        DataInputDeserializer inputView = this.keyDeserializerView.get();
        inputView.setBuffer(userKeyBytes, userKeyOffset, userKeyBytes.length - userKeyOffset);
        return (UK)this.userKeySerializer.get().deserialize((DataInputView)inputView);
    }

    @Override
    public ForStDBGetRequest<?, ?, ?, ?> buildDBGetRequest(StateRequest<?, ?, ?, ?> stateRequest) {
        Preconditions.checkArgument((stateRequest.getRequestType() == StateRequestType.MAP_GET || stateRequest.getRequestType() == StateRequestType.MAP_CONTAINS || stateRequest.getRequestType() == StateRequestType.MAP_IS_EMPTY ? 1 : 0) != 0);
        ContextKey contextKey = new ContextKey(stateRequest.getRecordContext(), stateRequest.getNamespace(), stateRequest.getPayload());
        if (stateRequest.getRequestType() == StateRequestType.MAP_GET) {
            return new ForStDBSingleGetRequest(contextKey, this, stateRequest.getFuture());
        }
        return new ForStDBMapCheckRequest(contextKey, this, (InternalAsyncFuture<Boolean>)stateRequest.getFuture(), stateRequest.getRequestType() == StateRequestType.MAP_IS_EMPTY);
    }

    @Override
    public ForStDBPutRequest<K, N, UV> buildDBPutRequest(StateRequest<?, ?, ?, ?> stateRequest) {
        ContextKey contextKey;
        Preconditions.checkNotNull((Object)stateRequest.getPayload());
        if (stateRequest.getRequestType() == StateRequestType.MAP_PUT) {
            contextKey = new ContextKey(stateRequest.getRecordContext(), stateRequest.getNamespace(), ((Tuple2)stateRequest.getPayload()).f0);
        } else if (stateRequest.getRequestType() == StateRequestType.MAP_REMOVE) {
            contextKey = new ContextKey(stateRequest.getRecordContext(), stateRequest.getNamespace(), stateRequest.getPayload());
        } else {
            throw new IllegalArgumentException("The State type is: " + stateRequest.getRequestType().name() + ", which is not a valid put request.");
        }
        Object value = null;
        if (stateRequest.getRequestType() == StateRequestType.MAP_PUT) {
            value = ((Tuple2)stateRequest.getPayload()).f1;
        }
        return ForStDBPutRequest.of(contextKey, value, this, (InternalAsyncFuture<Void>)stateRequest.getFuture());
    }

    public ForStDBBunchPutRequest<K, N, UK, UV> buildDBBunchPutRequest(StateRequest<?, ?, ?, ?> stateRequest) {
        Preconditions.checkArgument((stateRequest.getRequestType() == StateRequestType.MAP_PUT_ALL || stateRequest.getRequestType() == StateRequestType.CLEAR ? 1 : 0) != 0);
        ContextKey contextKey = new ContextKey(stateRequest.getRecordContext(), stateRequest.getNamespace(), null);
        Map value = (Map)stateRequest.getPayload();
        return new ForStDBBunchPutRequest(contextKey, value, this, (InternalAsyncFuture<Void>)stateRequest.getFuture());
    }

    public ForStDBIterRequest<K, N, UK, UV, ?> buildDBIterRequest(StateRequest<?, ?, ?, ?> stateRequest) {
        Preconditions.checkArgument((stateRequest.getRequestType() == StateRequestType.MAP_ITER || stateRequest.getRequestType() == StateRequestType.MAP_ITER_KEY || stateRequest.getRequestType() == StateRequestType.MAP_ITER_VALUE || stateRequest.getRequestType() == StateRequestType.ITERATOR_LOADING ? 1 : 0) != 0);
        RocksIterator rocksIterator = null;
        StateRequestType requestType = stateRequest.getRequestType();
        if (requestType == StateRequestType.ITERATOR_LOADING) {
            Tuple2 payload = (Tuple2)stateRequest.getPayload();
            requestType = (StateRequestType)payload.f0;
            rocksIterator = (RocksIterator)payload.f1;
        }
        return this.buildDBIterRequest(stateRequest, requestType, rocksIterator);
    }

    private ForStDBIterRequest<K, N, UK, UV, ?> buildDBIterRequest(StateRequest<?, ?, ?, ?> stateRequest, StateRequestType requestType, RocksIterator rocksIterator) {
        ContextKey contextKey = new ContextKey(stateRequest.getRecordContext(), stateRequest.getNamespace(), null);
        switch (requestType) {
            case MAP_ITER: {
                return new ForStDBMapEntryIterRequest(contextKey, this, this.stateRequestHandler, rocksIterator, stateRequest.getFuture());
            }
            case MAP_ITER_KEY: {
                return new ForStDBMapKeyIterRequest(contextKey, this, this.stateRequestHandler, rocksIterator, stateRequest.getFuture());
            }
            case MAP_ITER_VALUE: {
                return new ForStDBMapValueIterRequest(contextKey, this, this.stateRequestHandler, rocksIterator, stateRequest.getFuture());
            }
        }
        throw new IllegalArgumentException("Unknown request type: " + stateRequest + ", current request type: " + stateRequest.getRequestType());
    }

    static <N, UK, UV, K, SV, S extends State> S create(TypeSerializer<UK> userKeySerializer, TypeSerializer<UV> valueSerializer, StateRequestHandler stateRequestHandler, ColumnFamilyHandle columnFamily, Supplier<SerializedCompositeKeyBuilder<K>> serializedKeyBuilderInitializer, N defaultNamespace, Supplier<TypeSerializer<N>> namespaceSerializerInitializer, Supplier<DataOutputSerializer> valueSerializerViewInitializer, Supplier<DataInputDeserializer> keyDeserializerViewInitializer, Supplier<DataInputDeserializer> valueDeserializerViewInitializer, int keyGroupPrefixBytes) {
        return (S)new ForStMapState<K, N, UK, UV>(stateRequestHandler, columnFamily, userKeySerializer, valueSerializer, serializedKeyBuilderInitializer, defaultNamespace, namespaceSerializerInitializer, valueSerializerViewInitializer, keyDeserializerViewInitializer, valueDeserializerViewInitializer, keyGroupPrefixBytes);
    }
}

