/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog.restore;

import java.util.ArrayList;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.InternalKeyContext;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.internal.InternalMergingState;
import org.apache.flink.state.changelog.StateChangeOperation;
import org.apache.flink.state.changelog.restore.StateChangeApplier;

abstract class KvStateChangeApplier<K, N>
implements StateChangeApplier {
    private final InternalKeyContext<K> keyContext;

    protected abstract InternalKvState<K, N, ?> getState();

    protected KvStateChangeApplier(InternalKeyContext<K> keyContext) {
        this.keyContext = keyContext;
    }

    @Override
    public void apply(StateChangeOperation operation, DataInputView in) throws Exception {
        Object key = this.getState().getKeySerializer().deserialize(in);
        this.keyContext.setCurrentKey(key);
        this.keyContext.setCurrentKeyGroupIndex(KeyGroupRangeAssignment.assignToKeyGroup((Object)key, (int)this.keyContext.getNumberOfKeyGroups()));
        this.getState().setCurrentNamespace(this.getState().getNamespaceSerializer().deserialize(in));
        this.applyInternal(operation, in);
    }

    protected abstract void applyInternal(StateChangeOperation var1, DataInputView var2) throws Exception;

    protected static <K, N, T> void applyMergeNamespaces(InternalMergingState<K, N, T, ?, ?> state, DataInputView in) throws Exception {
        Object target = state.getNamespaceSerializer().deserialize(in);
        int sourcesSize = in.readInt();
        ArrayList<Object> sources = new ArrayList<Object>(sourcesSize);
        for (int i = 0; i < sourcesSize; ++i) {
            sources.add(state.getNamespaceSerializer().deserialize(in));
        }
        state.mergeNamespaces(target, sources);
    }
}

