/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog;

import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.flink.runtime.state.changelog.SequenceNumber;
import org.apache.flink.runtime.state.changelog.StateChangelogWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChangelogTruncateHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ChangelogTruncateHelper.class);
    private final StateChangelogWriter<?> stateChangelogWriter;
    private final NavigableMap<Long, SequenceNumber> checkpointedUpTo = new TreeMap<Long, SequenceNumber>();
    private SequenceNumber subsumedUpTo;
    private SequenceNumber materializedUpTo;

    ChangelogTruncateHelper(StateChangelogWriter<?> stateChangelogWriter) {
        this.stateChangelogWriter = stateChangelogWriter;
    }

    public void checkpoint(long checkpointId, SequenceNumber lastUploadedTo) {
        this.checkpointedUpTo.put(checkpointId, lastUploadedTo);
    }

    public void checkpointSubsumed(long checkpointId) {
        SequenceNumber sqn = (SequenceNumber)this.checkpointedUpTo.get(checkpointId);
        LOG.debug("checkpoint {} subsumed, max sqn: {}", (Object)checkpointId, (Object)sqn);
        if (sqn != null) {
            this.subsumedUpTo = sqn;
            this.checkpointedUpTo.headMap(checkpointId, true).clear();
            this.truncate();
        }
    }

    public void materialized(SequenceNumber upTo) {
        this.materializedUpTo = upTo;
        this.truncate();
    }

    private void truncate() {
        if (this.subsumedUpTo != null && this.materializedUpTo != null) {
            SequenceNumber to = this.subsumedUpTo.compareTo((Object)this.materializedUpTo) < 0 ? this.subsumedUpTo : this.materializedUpTo;
            LOG.debug("truncate changelog to {} (subsumed up to: {}, materialized up to: {})", new Object[]{to, this.subsumedUpTo, this.materializedUpTo});
            this.stateChangelogWriter.truncate(to);
        }
    }
}

