/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.table.module;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.state.table.SavepointMetadataTableFunction;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.DynamicBuiltInFunctionDefinitionFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.module.Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class StateModule
implements Module {
    private static final Logger LOG = LoggerFactory.getLogger(StateModule.class);
    public static final String IDENTIFIER = "state";
    public static final StateModule INSTANCE = new StateModule();
    private final Map<String, BuiltInFunctionDefinition> normalizedFunctions;
    private final Set<String> functionNamesWithInternal;
    private final Set<String> functionNamesWithoutInternal;

    private StateModule() {
        ArrayList<BuiltInFunctionDefinition> definitions = new ArrayList<BuiltInFunctionDefinition>();
        definitions.add(SavepointMetadataTableFunction.SAVEPOINT_METADATA);
        ServiceLoader.load(DynamicBuiltInFunctionDefinitionFactory.class).iterator().forEachRemaining(f -> {
            if (f.factoryIdentifier().startsWith("state.")) {
                definitions.addAll(f.getBuiltInFunctionDefinitions());
            }
        });
        StateModule.checkDuplicatedFunctions(definitions);
        this.normalizedFunctions = definitions.stream().collect(Collectors.toMap(f -> f.getName().toUpperCase(Locale.ROOT), Function.identity()));
        this.functionNamesWithInternal = definitions.stream().map(BuiltInFunctionDefinition::getName).collect(Collectors.toSet());
        this.functionNamesWithoutInternal = definitions.stream().filter(f -> !f.isInternal()).map(BuiltInFunctionDefinition::getName).collect(Collectors.toSet());
    }

    @VisibleForTesting
    static void checkDuplicatedFunctions(List<BuiltInFunctionDefinition> definitions) {
        HashSet<String> seen = new HashSet<String>();
        HashSet<String> duplicates = new HashSet<String>();
        for (BuiltInFunctionDefinition definition : definitions) {
            String name = definition.getName();
            if (seen.add(name)) continue;
            duplicates.add(name);
        }
        if (!duplicates.isEmpty()) {
            String error = "Duplicate function names found: " + String.join((CharSequence)",", duplicates);
            LOG.error(error);
            throw new IllegalStateException(error);
        }
    }

    public Set<String> listFunctions() {
        return this.listFunctions(false);
    }

    public Set<String> listFunctions(boolean includeHiddenFunctions) {
        if (includeHiddenFunctions) {
            return this.functionNamesWithInternal;
        }
        return this.functionNamesWithoutInternal;
    }

    public Optional<FunctionDefinition> getFunctionDefinition(String name) {
        String normalizedName = name.toUpperCase(Locale.ROOT);
        return Optional.ofNullable((FunctionDefinition)this.normalizedFunctions.get(normalizedName));
    }
}

