/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.dql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.SqlUnparseUtils;

public class SqlLoadModule
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("LOAD MODULE", SqlKind.OTHER);
    private final SqlIdentifier moduleName;
    private final SqlNodeList propertyList;

    public SqlLoadModule(SqlParserPos pos, SqlIdentifier moduleType, SqlNodeList propertyList) {
        super(pos);
        this.moduleName = Objects.requireNonNull(moduleType, "moduleName cannot be null");
        this.propertyList = Objects.requireNonNull(propertyList, "propertyList cannot be null");
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.moduleName, (Object)this.propertyList);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("LOAD MODULE");
        this.moduleName.unparse(writer, leftPrec, rightPrec);
        if (this.propertyList.size() > 0) {
            writer.keyword("WITH");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.propertyList) {
                SqlUnparseUtils.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }

    public SqlIdentifier getModuleName() {
        return this.moduleName;
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    public String moduleName() {
        return this.moduleName.getSimple();
    }
}

