/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.SqlUnparseUtils;
import org.apache.flink.sql.parser.ddl.SqlDistribution;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;

public class SqlCreateMaterializedTable
extends SqlCreate {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE MATERIALIZED TABLE", SqlKind.CREATE_TABLE);
    private final SqlIdentifier tableName;
    @Nullable
    private final SqlTableConstraint tableConstraint;
    @Nullable
    private final SqlCharStringLiteral comment;
    @Nullable
    private final SqlDistribution distribution;
    private final SqlNodeList partitionKeyList;
    private final SqlNodeList propertyList;
    private final SqlIntervalLiteral freshness;
    @Nullable
    private final SqlLiteral refreshMode;
    private final SqlNode asQuery;

    public SqlCreateMaterializedTable(SqlParserPos pos, SqlIdentifier tableName, @Nullable SqlTableConstraint tableConstraint, @Nullable SqlCharStringLiteral comment, @Nullable SqlDistribution distribution, SqlNodeList partitionKeyList, SqlNodeList propertyList, SqlIntervalLiteral freshness, @Nullable SqlLiteral refreshMode, SqlNode asQuery) {
        super((SqlOperator)OPERATOR, pos, false, false);
        this.tableName = Objects.requireNonNull(tableName, "tableName should not be null");
        this.tableConstraint = tableConstraint;
        this.comment = comment;
        this.distribution = distribution;
        this.partitionKeyList = Objects.requireNonNull(partitionKeyList, "partitionKeyList should not be null");
        this.propertyList = Objects.requireNonNull(propertyList, "propertyList should not be null");
        this.freshness = Objects.requireNonNull(freshness, "freshness should not be null");
        this.refreshMode = refreshMode;
        this.asQuery = Objects.requireNonNull(asQuery, "asQuery should not be null");
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.tableName, (Object)this.comment, (Object)((Object)this.tableConstraint), (Object)this.partitionKeyList, (Object)this.propertyList, (Object)this.freshness, (Object)this.asQuery);
    }

    public SqlIdentifier getTableName() {
        return this.tableName;
    }

    public String[] fullTableName() {
        return (String[])this.tableName.names.toArray((Object[])new String[0]);
    }

    public Optional<SqlCharStringLiteral> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public Optional<SqlTableConstraint> getTableConstraint() {
        return Optional.ofNullable(this.tableConstraint);
    }

    @Nullable
    public SqlDistribution getDistribution() {
        return this.distribution;
    }

    public SqlNodeList getPartitionKeyList() {
        return this.partitionKeyList;
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    public SqlIntervalLiteral getFreshness() {
        return this.freshness;
    }

    public Optional<SqlLiteral> getRefreshMode() {
        return Optional.ofNullable(this.refreshMode);
    }

    public SqlNode getAsQuery() {
        return this.asQuery;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE MATERIALIZED TABLE");
        this.tableName.unparse(writer, leftPrec, rightPrec);
        if (this.tableConstraint != null) {
            writer.newlineAndIndent();
            SqlUnparseUtils.unparseTableSchema(writer, leftPrec, rightPrec, SqlNodeList.EMPTY, Collections.singletonList(this.tableConstraint), null);
        }
        if (this.comment != null) {
            writer.newlineAndIndent();
            writer.keyword("COMMENT");
            this.comment.unparse(writer, leftPrec, rightPrec);
        }
        if (this.distribution != null) {
            writer.newlineAndIndent();
            this.distribution.unparse(writer, leftPrec, rightPrec);
        }
        if (!this.partitionKeyList.isEmpty()) {
            writer.newlineAndIndent();
            writer.keyword("PARTITIONED BY");
            SqlWriter.Frame partitionedByFrame = writer.startList("(", ")");
            this.partitionKeyList.unparse(writer, leftPrec, rightPrec);
            writer.endList(partitionedByFrame);
        }
        if (!this.propertyList.isEmpty()) {
            writer.newlineAndIndent();
            writer.keyword("WITH");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.propertyList) {
                SqlUnparseUtils.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
        writer.newlineAndIndent();
        writer.keyword("FRESHNESS");
        writer.keyword("=");
        this.freshness.unparse(writer, leftPrec, rightPrec);
        if (this.refreshMode != null) {
            writer.newlineAndIndent();
            writer.keyword("REFRESH_MODE");
            writer.keyword("=");
            this.refreshMode.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.keyword("AS");
        writer.newlineAndIndent();
        this.asQuery.unparse(writer, leftPrec, rightPrec);
    }
}

