/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public abstract class SqlAlterModel
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("ALTER MODEL", SqlKind.OTHER_DDL);
    protected final SqlIdentifier modelName;
    protected final boolean ifModelExists;

    public SqlAlterModel(SqlParserPos pos, SqlIdentifier modelName, boolean ifModelExists) {
        super(pos);
        this.modelName = Objects.requireNonNull(modelName, "modelName should not be null");
        this.ifModelExists = ifModelExists;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public SqlIdentifier getModelName() {
        return this.modelName;
    }

    public String[] fullModelName() {
        return (String[])this.modelName.names.toArray((Object[])new String[0]);
    }

    public boolean ifModelExists() {
        return this.ifModelExists;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ALTER MODEL");
        if (this.ifModelExists) {
            writer.keyword("IF EXISTS");
        }
        this.modelName.unparse(writer, leftPrec, rightPrec);
    }
}

