/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.ddl.SqlAlterMaterializedTable;
import org.apache.flink.sql.parser.ddl.SqlDistribution;

public class SqlAlterMaterializedTableAddDistribution
extends SqlAlterMaterializedTable {
    @Nullable
    protected final SqlDistribution distribution;

    public SqlAlterMaterializedTableAddDistribution(SqlParserPos pos, SqlIdentifier tableName, SqlDistribution distribution) {
        super(pos, tableName);
        this.distribution = distribution;
    }

    public List<SqlNode> getOperandList() {
        return List.of(this.getTableName(), this.distribution);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("ADD");
        if (this.distribution != null) {
            this.distribution.unparseAlter(writer, leftPrec, rightPrec);
        }
    }

    public Optional<SqlDistribution> getDistribution() {
        return Optional.ofNullable(this.distribution);
    }
}

