/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.vector;

import org.apache.flink.annotation.Internal;
import org.apache.flink.formats.parquet.utils.ParquetSchemaConverter;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.columnar.vector.BytesColumnVector;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.data.columnar.vector.DecimalColumnVector;
import org.apache.flink.table.data.columnar.vector.Dictionary;
import org.apache.flink.table.data.columnar.vector.IntColumnVector;
import org.apache.flink.table.data.columnar.vector.LongColumnVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableBytesVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableIntVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableLongVector;
import org.apache.flink.util.Preconditions;

@Internal
public class ParquetDecimalVector
implements DecimalColumnVector,
WritableLongVector,
WritableIntVector,
WritableBytesVector {
    private final ColumnVector vector;

    public ParquetDecimalVector(ColumnVector vector) {
        this.vector = vector;
    }

    public DecimalData getDecimal(int i, int precision, int scale) {
        if (ParquetSchemaConverter.is32BitDecimal(precision) && this.vector instanceof IntColumnVector) {
            return DecimalData.fromUnscaledLong((long)((IntColumnVector)this.vector).getInt(i), (int)precision, (int)scale);
        }
        if (ParquetSchemaConverter.is64BitDecimal(precision) && this.vector instanceof LongColumnVector) {
            return DecimalData.fromUnscaledLong((long)((LongColumnVector)this.vector).getLong(i), (int)precision, (int)scale);
        }
        Preconditions.checkArgument((boolean)(this.vector instanceof BytesColumnVector), (String)"Reading decimal type occur unsupported vector type: %s", (Object[])new Object[]{this.vector.getClass()});
        return DecimalData.fromUnscaledBytes((byte[])((BytesColumnVector)this.vector).getBytes(i).getBytes(), (int)precision, (int)scale);
    }

    public ColumnVector getVector() {
        return this.vector;
    }

    public boolean isNullAt(int i) {
        return this.vector.isNullAt(i);
    }

    public void reset() {
        if (this.vector instanceof WritableColumnVector) {
            ((WritableColumnVector)this.vector).reset();
        }
    }

    public void setNullAt(int rowId) {
        if (this.vector instanceof WritableColumnVector) {
            ((WritableColumnVector)this.vector).setNullAt(rowId);
        }
    }

    public void setNulls(int rowId, int count) {
        if (this.vector instanceof WritableColumnVector) {
            ((WritableColumnVector)this.vector).setNulls(rowId, count);
        }
    }

    public void fillWithNulls() {
        if (this.vector instanceof WritableColumnVector) {
            ((WritableColumnVector)this.vector).fillWithNulls();
        }
    }

    public void setDictionary(Dictionary dictionary) {
        if (this.vector instanceof WritableColumnVector) {
            ((WritableColumnVector)this.vector).setDictionary(dictionary);
        }
    }

    public boolean hasDictionary() {
        if (this.vector instanceof WritableColumnVector) {
            return ((WritableColumnVector)this.vector).hasDictionary();
        }
        return false;
    }

    public WritableIntVector reserveDictionaryIds(int capacity) {
        if (this.vector instanceof WritableColumnVector) {
            return ((WritableColumnVector)this.vector).reserveDictionaryIds(capacity);
        }
        throw new RuntimeException("Child vector must be instance of WritableColumnVector");
    }

    public WritableIntVector getDictionaryIds() {
        if (this.vector instanceof WritableColumnVector) {
            return ((WritableColumnVector)this.vector).getDictionaryIds();
        }
        throw new RuntimeException("Child vector must be instance of WritableColumnVector");
    }

    public BytesColumnVector.Bytes getBytes(int i) {
        if (this.vector instanceof WritableBytesVector) {
            return ((WritableBytesVector)this.vector).getBytes(i);
        }
        throw new RuntimeException("Child vector must be instance of WritableColumnVector");
    }

    public void appendBytes(int rowId, byte[] value, int offset, int length) {
        if (this.vector instanceof WritableBytesVector) {
            ((WritableBytesVector)this.vector).appendBytes(rowId, value, offset, length);
        }
    }

    public void fill(byte[] value) {
        if (this.vector instanceof WritableBytesVector) {
            ((WritableBytesVector)this.vector).fill(value);
        }
    }

    public int getInt(int i) {
        if (this.vector instanceof WritableIntVector) {
            return ((WritableIntVector)this.vector).getInt(i);
        }
        throw new RuntimeException("Child vector must be instance of WritableColumnVector");
    }

    public void setInt(int rowId, int value) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).setInt(rowId, value);
        }
    }

    public void setIntsFromBinary(int rowId, int count, byte[] src, int srcIndex) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).setIntsFromBinary(rowId, count, src, srcIndex);
        }
    }

    public void setInts(int rowId, int count, int value) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).setInts(rowId, count, value);
        }
    }

    public void setInts(int rowId, int count, int[] src, int srcIndex) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).setInts(rowId, count, src, srcIndex);
        }
    }

    public void fill(int value) {
        if (this.vector instanceof WritableIntVector) {
            ((WritableIntVector)this.vector).fill(value);
        }
    }

    public long getLong(int i) {
        if (this.vector instanceof WritableLongVector) {
            return ((WritableLongVector)this.vector).getLong(i);
        }
        throw new RuntimeException("Child vector must be instance of WritableColumnVector");
    }

    public void setLong(int rowId, long value) {
        if (this.vector instanceof WritableLongVector) {
            ((WritableLongVector)this.vector).setLong(rowId, value);
        }
    }

    public void setLongsFromBinary(int rowId, int count, byte[] src, int srcIndex) {
        if (this.vector instanceof WritableLongVector) {
            ((WritableLongVector)this.vector).setLongsFromBinary(rowId, count, src, srcIndex);
        }
    }

    public void fill(long value) {
        if (this.vector instanceof WritableLongVector) {
            ((WritableLongVector)this.vector).fill(value);
        }
    }
}

