/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.avro;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericData;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.formats.parquet.ParquetInputFile;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SerializableSupplier;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AvroParquetRecordFormat<E>
implements StreamFormat<E> {
    private static final long serialVersionUID = 1L;
    static final Logger LOG = LoggerFactory.getLogger(AvroParquetRecordFormat.class);
    private final TypeInformation<E> type;
    private final SerializableSupplier<GenericData> dataModelSupplier;

    AvroParquetRecordFormat(TypeInformation<E> type, SerializableSupplier<GenericData> dataModelSupplier) {
        this.type = type;
        this.dataModelSupplier = dataModelSupplier;
    }

    public StreamFormat.Reader<E> createReader(Configuration config, FSDataInputStream stream, long fileLen, long splitEnd) throws IOException {
        AvroParquetRecordFormat.checkNotSplit(fileLen, splitEnd);
        return new AvroParquetRecordReader(AvroParquetReader.builder(new ParquetInputFile(stream, fileLen)).withDataModel(this.getDataModel()).withConf(HadoopUtils.getHadoopConfiguration((Configuration)config)).build());
    }

    public StreamFormat.Reader<E> restoreReader(Configuration config, FSDataInputStream stream, long restoredOffset, long fileLen, long splitEnd) throws IOException {
        AvroParquetRecordFormat.checkNotSplit(fileLen, splitEnd);
        Preconditions.checkArgument((restoredOffset == -1L ? 1 : 0) != 0, (Object)"The restoredOffset should always be NO_OFFSET");
        return this.createReader(config, stream, fileLen, splitEnd);
    }

    @VisibleForTesting
    GenericData getDataModel() {
        return (GenericData)this.dataModelSupplier.get();
    }

    public boolean isSplittable() {
        return false;
    }

    public TypeInformation<E> getProducedType() {
        return this.type;
    }

    private static void checkNotSplit(long fileLen, long splitEnd) {
        if (splitEnd != fileLen) {
            throw new IllegalArgumentException(String.format("Current version of AvroParquetRecordFormat is not splittable, but found split end (%d) different from file length (%d)", splitEnd, fileLen));
        }
    }

    private static class AvroParquetRecordReader<E>
    implements StreamFormat.Reader<E> {
        private final ParquetReader<E> parquetReader;
        private long skipCount;
        private final boolean checkpointed;

        private AvroParquetRecordReader(ParquetReader<E> parquetReader) {
            this(parquetReader, 0L, false);
        }

        private AvroParquetRecordReader(ParquetReader<E> parquetReader, long skipCount, boolean checkpointed) {
            this.parquetReader = parquetReader;
            this.skipCount = skipCount;
            this.checkpointed = checkpointed;
        }

        @Nullable
        public E read() throws IOException {
            E record = this.parquetReader.read();
            this.incrementPosition();
            return record;
        }

        public void close() throws IOException {
            this.parquetReader.close();
        }

        @Nullable
        public CheckpointedPosition getCheckpointedPosition() {
            return this.checkpointed ? new CheckpointedPosition(-1L, this.skipCount) : null;
        }

        private void incrementPosition() {
            ++this.skipCount;
        }
    }
}

