/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.io.Text;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcProto;
import org.apache.orc.StringColumnStatistics;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.DynamicIntArray;
import org.apache.orc.impl.IntegerWriter;
import org.apache.orc.impl.OutStream;
import org.apache.orc.impl.PositionedOutputStream;
import org.apache.orc.impl.StringRedBlackTree;
import org.apache.orc.impl.writer.TreeWriterBase;
import org.apache.orc.impl.writer.WriterContext;

public abstract class StringBaseTreeWriter
extends TreeWriterBase {
    private static final int INITIAL_DICTIONARY_SIZE = 4096;
    private final OutStream stringOutput;
    protected final IntegerWriter lengthOutput;
    private final IntegerWriter rowOutput;
    protected final StringRedBlackTree dictionary = new StringRedBlackTree(4096);
    protected final DynamicIntArray rows = new DynamicIntArray();
    protected final PositionedOutputStream directStreamOutput;
    private final List<OrcProto.RowIndexEntry> savedRowIndex = new ArrayList<OrcProto.RowIndexEntry>();
    private final boolean buildIndex;
    private final List<Long> rowIndexValueCount = new ArrayList<Long>();
    private final double dictionaryKeySizeThreshold;
    protected boolean useDictionaryEncoding = true;
    private boolean isDirectV2 = true;
    private boolean doneDictionaryCheck;
    private final boolean strideDictionaryCheck;

    StringBaseTreeWriter(int columnId, TypeDescription schema, WriterContext writer, boolean nullable) throws IOException {
        super(columnId, schema, writer, nullable);
        this.isDirectV2 = this.isNewWriteFormat(writer);
        this.directStreamOutput = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
        this.stringOutput = writer.createStream(this.id, OrcProto.Stream.Kind.DICTIONARY_DATA);
        this.lengthOutput = this.createIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.LENGTH), false, this.isDirectV2, writer);
        this.rowOutput = this.createIntegerWriter(this.directStreamOutput, false, this.isDirectV2, writer);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
        this.rowIndexValueCount.add(0L);
        this.buildIndex = writer.buildIndex();
        Configuration conf = writer.getConfiguration();
        this.dictionaryKeySizeThreshold = writer.getDictionaryKeySizeThreshold(columnId);
        this.strideDictionaryCheck = OrcConf.ROW_INDEX_STRIDE_DICTIONARY_CHECK.getBoolean(conf);
        if (this.dictionaryKeySizeThreshold <= 0.0) {
            this.useDictionaryEncoding = false;
            this.doneDictionaryCheck = true;
        } else {
            this.doneDictionaryCheck = false;
        }
    }

    private void checkDictionaryEncoding() {
        if (!this.doneDictionaryCheck) {
            float ratio = this.rows.size() > 0 ? (float)this.dictionary.size() / (float)this.rows.size() : 0.0f;
            this.useDictionaryEncoding = !this.isDirectV2 || (double)ratio <= this.dictionaryKeySizeThreshold;
            this.doneDictionaryCheck = true;
        }
    }

    @Override
    public void writeStripe(OrcProto.StripeFooter.Builder builder, OrcProto.StripeStatistics.Builder stats, int requiredIndexEntries) throws IOException {
        this.checkDictionaryEncoding();
        if (!this.useDictionaryEncoding) {
            this.stringOutput.suppress();
        }
        super.writeStripe(builder, stats, requiredIndexEntries);
        this.dictionary.clear();
        this.savedRowIndex.clear();
        this.rowIndexValueCount.clear();
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
        this.rowIndexValueCount.add(0L);
        if (!this.useDictionaryEncoding) {
            this.recordDirectStreamPosition();
        }
    }

    private void flushDictionary() throws IOException {
        final int[] dumpOrder = new int[this.dictionary.size()];
        if (this.useDictionaryEncoding) {
            this.dictionary.visit(new StringRedBlackTree.Visitor(){
                private int currentId = 0;

                @Override
                public void visit(StringRedBlackTree.VisitorContext context) throws IOException {
                    context.writeBytes(StringBaseTreeWriter.this.stringOutput);
                    StringBaseTreeWriter.this.lengthOutput.write(context.getLength());
                    dumpOrder[context.getOriginalPosition()] = this.currentId++;
                }
            });
        } else {
            this.stringOutput.suppress();
        }
        int length = this.rows.size();
        int rowIndexEntry = 0;
        OrcProto.RowIndex.Builder rowIndex = this.getRowIndex();
        Text text = new Text();
        for (int i = 0; i <= length; ++i) {
            if (this.buildIndex) {
                while ((long)i == this.rowIndexValueCount.get(rowIndexEntry) && rowIndexEntry < this.savedRowIndex.size()) {
                    OrcProto.RowIndexEntry.Builder base = this.savedRowIndex.get(rowIndexEntry++).toBuilder();
                    if (this.useDictionaryEncoding) {
                        this.rowOutput.getPosition(new TreeWriterBase.RowIndexPositionRecorder(base));
                    } else {
                        TreeWriterBase.RowIndexPositionRecorder posn = new TreeWriterBase.RowIndexPositionRecorder(base);
                        this.directStreamOutput.getPosition(posn);
                        this.lengthOutput.getPosition(posn);
                    }
                    rowIndex.addEntry(base.build());
                }
            }
            if (i == length) continue;
            if (this.useDictionaryEncoding) {
                this.rowOutput.write(dumpOrder[this.rows.get(i)]);
                continue;
            }
            this.dictionary.getText(text, this.rows.get(i));
            this.directStreamOutput.write(text.getBytes(), 0, text.getLength());
            this.lengthOutput.write(text.getLength());
        }
        this.rows.clear();
    }

    @Override
    OrcProto.ColumnEncoding.Builder getEncoding() {
        OrcProto.ColumnEncoding.Builder result = super.getEncoding();
        if (this.useDictionaryEncoding) {
            result.setDictionarySize(this.dictionary.size());
            if (this.isDirectV2) {
                result.setKind(OrcProto.ColumnEncoding.Kind.DICTIONARY_V2);
            } else {
                result.setKind(OrcProto.ColumnEncoding.Kind.DICTIONARY);
            }
        } else if (this.isDirectV2) {
            result.setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2);
        } else {
            result.setKind(OrcProto.ColumnEncoding.Kind.DIRECT);
        }
        return result;
    }

    @Override
    public void createRowIndexEntry() throws IOException {
        this.getStripeStatistics().merge(this.indexStatistics);
        OrcProto.RowIndexEntry.Builder rowIndexEntry = this.getRowIndexEntry();
        rowIndexEntry.setStatistics(this.indexStatistics.serialize());
        this.indexStatistics.reset();
        OrcProto.RowIndexEntry base = rowIndexEntry.build();
        this.savedRowIndex.add(base);
        rowIndexEntry.clear();
        this.addBloomFilterEntry();
        this.recordPosition(this.rowIndexPosition);
        this.rowIndexValueCount.add(Long.valueOf(this.rows.size()));
        if (this.strideDictionaryCheck) {
            this.checkDictionaryEncoding();
        }
        if (!this.useDictionaryEncoding) {
            if (this.rows.size() > 0) {
                this.flushDictionary();
                this.recordDirectStreamPosition();
            } else {
                this.recordDirectStreamPosition();
                this.getRowIndex().addEntry(base);
            }
        }
    }

    private void recordDirectStreamPosition() throws IOException {
        if (this.rowIndexPosition != null) {
            this.directStreamOutput.getPosition(this.rowIndexPosition);
            this.lengthOutput.getPosition(this.rowIndexPosition);
        }
    }

    @Override
    public long estimateMemory() {
        long parent = super.estimateMemory();
        if (this.useDictionaryEncoding) {
            return parent + this.dictionary.getSizeInBytes() + (long)this.rows.getSizeInBytes();
        }
        return parent + this.lengthOutput.estimateMemory() + this.directStreamOutput.getBufferSize();
    }

    @Override
    public long getRawDataSize() {
        StringColumnStatistics scs = (StringColumnStatistics)((Object)this.fileStatistics);
        long numVals = this.fileStatistics.getNumberOfValues();
        if (numVals == 0L) {
            return 0L;
        }
        int avgSize = (int)(scs.getSum() / numVals);
        return numVals * (long)JavaDataModel.get().lengthForStringOfLength(avgSize);
    }

    @Override
    public void flushStreams() throws IOException {
        super.flushStreams();
        this.checkDictionaryEncoding();
        if (this.useDictionaryEncoding) {
            this.flushDictionary();
            this.stringOutput.flush();
            this.lengthOutput.flush();
            this.rowOutput.flush();
        } else {
            if (this.rows.size() > 0) {
                this.flushDictionary();
            }
            this.stringOutput.suppress();
            this.directStreamOutput.flush();
            this.lengthOutput.flush();
        }
    }
}

