/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.utils;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import org.apache.flink.shaded.guava33.com.google.common.io.Files;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.Preconditions;

public class MockHttpServer
implements Closeable {
    private static final String HTTP_PROTOCOL = "http";
    private final HttpServer server;
    private final NetUtils.Port port;

    private MockHttpServer(HttpServer server, NetUtils.Port port) {
        this.server = server;
        this.port = port;
    }

    public static MockHttpServer startHttpServer() throws IOException {
        NetUtils.Port port = NetUtils.getAvailablePort();
        HttpServer httpServer = HttpServer.create(new InetSocketAddress(port.getPort()), 0);
        httpServer.setExecutor(null);
        httpServer.start();
        return new MockHttpServer(httpServer, port);
    }

    public URL prepareResource(String path, File fileToDownload) throws Exception {
        this.server.createContext(path, new DownloadFileHttpHandler(fileToDownload));
        return new URL(HTTP_PROTOCOL, InetAddress.getLocalHost().getHostAddress(), this.port.getPort(), path);
    }

    @Override
    public void close() throws IOException {
        this.server.stop(0);
        try {
            this.port.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class DownloadFileHttpHandler
    implements HttpHandler {
        private static final String CONTENT_TYPE_KEY = "Content-Type";
        private static final String CONTENT_TYPE_VALUE = "application/octet-stream";
        private final File file;

        public DownloadFileHttpHandler(File fileToDownload) {
            Preconditions.checkArgument((boolean)fileToDownload.exists(), (Object)"The file to be download not exists!");
            this.file = fileToDownload;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            exchange.getResponseHeaders().add(CONTENT_TYPE_KEY, CONTENT_TYPE_VALUE);
            exchange.sendResponseHeaders(200, this.file.length());
            Files.copy((File)this.file, (OutputStream)exchange.getResponseBody());
            exchange.close();
        }
    }
}

