/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.rest.SqlGatewayRestEndpoint;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestEndpointTestUtils;
import org.apache.flink.util.Preconditions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class SqlGatewayRestEndpointExtension
implements BeforeAllCallback,
AfterAllCallback {
    private final Supplier<SqlGatewayService> serviceSupplier;
    private final Consumer<Configuration> flinkConfConsumer;
    private SqlGatewayRestEndpoint sqlGatewayRestEndpoint;
    private SqlGatewayService sqlGatewayService;
    private String targetAddress;
    private int targetPort;

    public String getTargetAddress() {
        return this.targetAddress;
    }

    public int getTargetPort() {
        return this.targetPort;
    }

    public SqlGatewayService getSqlGatewayService() {
        return this.sqlGatewayService;
    }

    public SqlGatewayRestEndpoint getSqlGatewayRestEndpoint() {
        return this.sqlGatewayRestEndpoint;
    }

    public SqlGatewayRestEndpointExtension(Supplier<SqlGatewayService> serviceSupplier) {
        this(serviceSupplier, conf -> {});
    }

    public SqlGatewayRestEndpointExtension(Supplier<SqlGatewayService> serviceSupplier, Consumer<Configuration> flinkConfConsumer) {
        this.serviceSupplier = serviceSupplier;
        this.flinkConfConsumer = flinkConfConsumer;
    }

    public void beforeAll(ExtensionContext context) {
        String address = InetAddress.getLoopbackAddress().getHostAddress();
        Configuration flinkConfig = SqlGatewayRestEndpointTestUtils.getFlinkConfig(address, address, "0");
        this.flinkConfConsumer.accept(flinkConfig);
        Configuration config = SqlGatewayRestEndpointTestUtils.getBaseConfig(flinkConfig);
        try {
            this.sqlGatewayService = this.serviceSupplier.get();
            this.sqlGatewayRestEndpoint = new SqlGatewayRestEndpoint(config, this.sqlGatewayService);
            this.sqlGatewayRestEndpoint.start();
        }
        catch (Exception e) {
            throw new SqlGatewayException("Unexpected error occurred when trying to start the rest endpoint of sql gateway.", (Throwable)e);
        }
        InetSocketAddress serverAddress = (InetSocketAddress)Preconditions.checkNotNull((Object)this.sqlGatewayRestEndpoint.getServerAddress());
        this.targetAddress = serverAddress.getHostName();
        this.targetPort = serverAddress.getPort();
    }

    public void afterAll(ExtensionContext context) {
        try {
            this.sqlGatewayRestEndpoint.stop();
        }
        catch (Exception e) {
            throw new SqlGatewayException("Unexpected error occurred when trying to stop the rest endpoint of sql gateway.", (Throwable)e);
        }
    }
}

