/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.rest.RestAPIITCaseBase;
import org.apache.flink.table.gateway.rest.header.session.CloseSessionHeaders;
import org.apache.flink.table.gateway.rest.header.session.ConfigureSessionHeaders;
import org.apache.flink.table.gateway.rest.header.session.GetSessionConfigHeaders;
import org.apache.flink.table.gateway.rest.header.session.OpenSessionHeaders;
import org.apache.flink.table.gateway.rest.header.session.TriggerSessionHeartbeatHeaders;
import org.apache.flink.table.gateway.rest.message.session.CloseSessionResponseBody;
import org.apache.flink.table.gateway.rest.message.session.ConfigureSessionRequestBody;
import org.apache.flink.table.gateway.rest.message.session.GetSessionConfigResponseBody;
import org.apache.flink.table.gateway.rest.message.session.OpenSessionRequestBody;
import org.apache.flink.table.gateway.rest.message.session.OpenSessionResponseBody;
import org.apache.flink.table.gateway.rest.message.session.SessionMessageParameters;
import org.apache.flink.table.gateway.service.session.Session;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SessionRelatedITCase
extends RestAPIITCaseBase {
    private static final String SESSION_NAME = "test";
    private static final Map<String, String> properties = new HashMap<String, String>();
    private static final int SESSION_NUMBER = 10;
    private static final OpenSessionHeaders openSessionHeaders;
    private static final OpenSessionRequestBody openSessionRequestBody;
    private static final EmptyMessageParameters emptyParameters;
    private static final CloseSessionHeaders closeSessionHeaders;
    private static final EmptyRequestBody emptyRequestBody;
    private SessionHandle sessionHandle;
    private SessionMessageParameters sessionMessageParameters;

    SessionRelatedITCase() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        CompletableFuture response = this.sendRequest(openSessionHeaders, emptyParameters, openSessionRequestBody);
        String sessionHandleId = ((OpenSessionResponseBody)response.get()).getSessionHandle();
        Assertions.assertThat((String)sessionHandleId).isNotNull();
        this.sessionHandle = new SessionHandle(UUID.fromString(sessionHandleId));
        Assertions.assertThat((Object)SQL_GATEWAY_SERVICE_EXTENSION.getSessionManager().getSession(this.sessionHandle)).isNotNull();
        this.sessionMessageParameters = new SessionMessageParameters(this.sessionHandle);
    }

    @AfterEach
    public void cleanUp() throws Exception {
        CompletableFuture response = this.sendRequest(closeSessionHeaders, this.sessionMessageParameters, emptyRequestBody);
        String status = ((CloseSessionResponseBody)response.get()).getStatus();
        Assertions.assertThat((String)status).isEqualTo("CLOSED");
    }

    @Test
    void testCreateAndCloseSessions() throws Exception {
        int num;
        ArrayList<SessionHandle> sessionHandles = new ArrayList<SessionHandle>();
        HashSet<String> sessionHandleIds = new HashSet<String>();
        for (num = 0; num < 10; ++num) {
            CompletableFuture response = this.sendRequest(openSessionHeaders, emptyParameters, openSessionRequestBody);
            String sessionHandleId = ((OpenSessionResponseBody)response.get()).getSessionHandle();
            Assertions.assertThat((String)sessionHandleId).isNotNull();
            sessionHandleIds.add(sessionHandleId);
            SessionHandle sessionHandle = new SessionHandle(UUID.fromString(sessionHandleId));
            Assertions.assertThat((Object)SQL_GATEWAY_SERVICE_EXTENSION.getSessionManager().getSession(sessionHandle)).isNotNull();
            sessionHandles.add(sessionHandle);
        }
        Assertions.assertThat(sessionHandleIds).hasSize(10);
        for (num = 0; num < 10; ++num) {
            SessionHandle sessionHandle = (SessionHandle)sessionHandles.get(num);
            SessionMessageParameters sessionMessageParameters = new SessionMessageParameters(sessionHandle);
            CompletableFuture response = this.sendRequest(closeSessionHeaders, sessionMessageParameters, emptyRequestBody);
            String status = ((CloseSessionResponseBody)response.get()).getStatus();
            Assertions.assertThat((String)status).isEqualTo("CLOSED");
            Assertions.assertThatThrownBy(() -> SQL_GATEWAY_SERVICE_EXTENSION.getSessionManager().getSession(sessionHandle)).isInstanceOf(SqlGatewayException.class);
            CompletableFuture response2 = this.sendRequest(closeSessionHeaders, sessionMessageParameters, emptyRequestBody);
            Assertions.assertThatThrownBy(response2::get).isInstanceOf(ExecutionException.class);
        }
    }

    @Test
    void testGetSessionConfiguration() throws Exception {
        CompletableFuture future = this.sendRequest(GetSessionConfigHeaders.getInstance(), this.sessionMessageParameters, emptyRequestBody);
        Map getProperties = ((GetSessionConfigResponseBody)future.get()).getProperties();
        for (String key : properties.keySet()) {
            Assertions.assertThat(properties).containsEntry((Object)key, (Object)((String)getProperties.get(key)));
        }
    }

    @Test
    void testTouchSession() throws Exception {
        Session session = SQL_GATEWAY_SERVICE_EXTENSION.getSessionManager().getSession(this.sessionHandle);
        Assertions.assertThat((Object)session).isNotNull();
        long lastAccessTime = session.getLastAccessTime();
        CompletableFuture future = this.sendRequest(TriggerSessionHeartbeatHeaders.getInstance(), this.sessionMessageParameters, emptyRequestBody);
        future.get();
        Assertions.assertThat((long)session.getLastAccessTime()).isGreaterThan(lastAccessTime);
    }

    @Test
    void testConfigureSession() throws Exception {
        ConfigureSessionRequestBody configureSessionRequestBody = new ConfigureSessionRequestBody("set 'test' = 'configure';", Long.valueOf(-1L));
        CompletableFuture response = this.sendRequest(ConfigureSessionHeaders.getInstance(), this.sessionMessageParameters, configureSessionRequestBody);
        response.get();
        Assertions.assertThat((Map)SQL_GATEWAY_SERVICE_EXTENSION.getSessionManager().getSession(this.sessionHandle).getSessionConfig()).containsEntry((Object)SESSION_NAME, (Object)"configure");
    }

    static {
        properties.put("k1", "v1");
        properties.put("k2", "v2");
        openSessionHeaders = OpenSessionHeaders.getInstance();
        openSessionRequestBody = new OpenSessionRequestBody(SESSION_NAME, properties);
        emptyParameters = EmptyMessageParameters.getInstance();
        closeSessionHeaders = CloseSessionHeaders.getInstance();
        emptyRequestBody = EmptyRequestBody.getInstance();
    }
}

