/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.loading;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.scheduler.loading.LoadingWeight;
import org.apache.flink.util.Preconditions;

@Internal
public class DefaultLoadingWeight
implements LoadingWeight {
    public static final LoadingWeight EMPTY = new DefaultLoadingWeight(0.0f);
    private final float loading;

    public DefaultLoadingWeight(float loading) {
        Preconditions.checkArgument((loading >= 0.0f ? 1 : 0) != 0);
        this.loading = loading;
    }

    @Override
    public float getLoading() {
        return this.loading;
    }

    @Override
    public LoadingWeight merge(LoadingWeight other) {
        if (other == null) {
            return this;
        }
        return new DefaultLoadingWeight(this.loading + other.getLoading());
    }

    @Override
    public int compareTo(@Nonnull LoadingWeight o) {
        return Float.compare(this.loading, o.getLoading());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLoadingWeight that = (DefaultLoadingWeight)o;
        return (float)Float.compare(this.loading, that.loading) == 0.0f;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.loading));
    }

    public String toString() {
        return "DefaultLoadingWeight{loading=" + this.loading + "}";
    }
}

