/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.scheduler.AbstractSlotSharingStrategy;
import org.apache.flink.runtime.scheduler.ExecutionSlotSharingGroup;
import org.apache.flink.runtime.scheduler.SlotSharingStrategy;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.util.Preconditions;

class LocalInputPreferredSlotSharingStrategy
extends AbstractSlotSharingStrategy {
    LocalInputPreferredSlotSharingStrategy(SchedulingTopology topology, Set<SlotSharingGroup> logicalSlotSharingGroups, Set<CoLocationGroup> coLocationGroups) {
        super(topology, logicalSlotSharingGroups, coLocationGroups);
    }

    @Override
    protected Map<ExecutionVertexID, ExecutionSlotSharingGroup> computeExecutionSlotSharingGroups(SchedulingTopology schedulingTopology) {
        return new LocalInputPreferredExecutionSlotSharingGroupBuilder(schedulingTopology, this.logicalSlotSharingGroups, this.coLocationGroups).build();
    }

    private static class LocalInputPreferredExecutionSlotSharingGroupBuilder {
        private final SchedulingTopology topology;
        private final Map<JobVertexID, SlotSharingGroup> slotSharingGroupMap;
        private final Map<JobVertexID, CoLocationGroup> coLocationGroupMap;
        private final Map<ExecutionVertexID, ExecutionSlotSharingGroup> executionSlotSharingGroupMap;
        private final Map<CoLocationConstraint, ExecutionSlotSharingGroup> constraintToExecutionSlotSharingGroupMap;
        private final Map<JobVertexID, LinkedHashSet<ExecutionSlotSharingGroup>> availableGroupsForJobVertex;
        private final Map<ConsumedPartitionGroup, LinkedHashSet<ExecutionSlotSharingGroup>> candidateGroupsForConsumedPartitionGroup;

        private LocalInputPreferredExecutionSlotSharingGroupBuilder(SchedulingTopology topology, Set<SlotSharingGroup> logicalSlotSharingGroups, Set<CoLocationGroup> coLocationGroups) {
            this.topology = (SchedulingTopology)Preconditions.checkNotNull((Object)topology);
            this.slotSharingGroupMap = new HashMap<JobVertexID, SlotSharingGroup>();
            for (SlotSharingGroup slotSharingGroup : logicalSlotSharingGroups) {
                for (JobVertexID jobVertexId : slotSharingGroup.getJobVertexIds()) {
                    this.slotSharingGroupMap.put(jobVertexId, slotSharingGroup);
                }
            }
            this.coLocationGroupMap = new HashMap<JobVertexID, CoLocationGroup>();
            for (CoLocationGroup coLocationGroup : coLocationGroups) {
                for (JobVertexID jobVertexId : coLocationGroup.getVertexIds()) {
                    this.coLocationGroupMap.put(jobVertexId, coLocationGroup);
                }
            }
            this.executionSlotSharingGroupMap = new HashMap<ExecutionVertexID, ExecutionSlotSharingGroup>();
            this.constraintToExecutionSlotSharingGroupMap = new HashMap<CoLocationConstraint, ExecutionSlotSharingGroup>();
            this.availableGroupsForJobVertex = new HashMap<JobVertexID, LinkedHashSet<ExecutionSlotSharingGroup>>();
            this.candidateGroupsForConsumedPartitionGroup = new IdentityHashMap<ConsumedPartitionGroup, LinkedHashSet<ExecutionSlotSharingGroup>>();
        }

        private Map<ExecutionVertexID, ExecutionSlotSharingGroup> build() {
            LinkedHashMap allVertices = AbstractSlotSharingStrategy.getExecutionVertices(this.topology, Function.identity());
            for (List<SchedulingExecutionVertex> list : allVertices.values()) {
                List<SchedulingExecutionVertex> remaining = this.tryFindOptimalAvailableExecutionSlotSharingGroupFor(list);
                this.findAvailableOrCreateNewExecutionSlotSharingGroupFor(remaining);
                this.updateConstraintToExecutionSlotSharingGroupMap(list);
            }
            return this.executionSlotSharingGroupMap;
        }

        private List<SchedulingExecutionVertex> tryFindOptimalAvailableExecutionSlotSharingGroupFor(List<SchedulingExecutionVertex> executionVertices) {
            ArrayList<SchedulingExecutionVertex> remaining = new ArrayList<SchedulingExecutionVertex>();
            for (SchedulingExecutionVertex executionVertex : executionVertices) {
                ExecutionSlotSharingGroup group = this.tryFindAvailableCoLocatedExecutionSlotSharingGroupFor(executionVertex);
                if (group == null) {
                    group = this.tryFindAvailableProducerExecutionSlotSharingGroupFor(executionVertex);
                }
                if (group == null) {
                    remaining.add(executionVertex);
                    continue;
                }
                this.addVertexToExecutionSlotSharingGroup(executionVertex, group);
            }
            return remaining;
        }

        private ExecutionSlotSharingGroup tryFindAvailableCoLocatedExecutionSlotSharingGroupFor(SchedulingExecutionVertex executionVertex) {
            ExecutionVertexID executionVertexId = (ExecutionVertexID)executionVertex.getId();
            CoLocationGroup coLocationGroup = this.coLocationGroupMap.get(executionVertexId.getJobVertexId());
            if (coLocationGroup != null) {
                CoLocationConstraint constraint = coLocationGroup.getLocationConstraint(executionVertexId.getSubtaskIndex());
                return this.constraintToExecutionSlotSharingGroupMap.get(constraint);
            }
            return null;
        }

        private ExecutionSlotSharingGroup tryFindAvailableProducerExecutionSlotSharingGroupFor(SchedulingExecutionVertex executionVertex) {
            ExecutionVertexID executionVertexId = (ExecutionVertexID)executionVertex.getId();
            for (ConsumedPartitionGroup consumedPartitionGroup : executionVertex.getConsumedPartitionGroups()) {
                Set candidateGroups = this.candidateGroupsForConsumedPartitionGroup.computeIfAbsent(consumedPartitionGroup, group -> this.computeAllCandidateGroupsForConsumedPartitionGroup(executionVertexId.getJobVertexId(), (ConsumedPartitionGroup)group));
                Iterator candidateIterator = candidateGroups.iterator();
                while (candidateIterator.hasNext()) {
                    ExecutionSlotSharingGroup candidateGroup = (ExecutionSlotSharingGroup)candidateIterator.next();
                    candidateIterator.remove();
                    if (!this.isExecutionSlotSharingGroupAvailableForVertex(candidateGroup, executionVertexId)) continue;
                    return candidateGroup;
                }
            }
            return null;
        }

        private boolean isExecutionSlotSharingGroupAvailableForVertex(ExecutionSlotSharingGroup executionSlotSharingGroup, ExecutionVertexID vertexId) {
            Set availableGroupsForCurrentVertex = this.availableGroupsForJobVertex.get(vertexId.getJobVertexId());
            return availableGroupsForCurrentVertex != null && availableGroupsForCurrentVertex.contains(executionSlotSharingGroup);
        }

        private boolean inSameLogicalSlotSharingGroup(JobVertexID jobVertexId1, JobVertexID jobVertexId2) {
            return Objects.equals((Object)this.getSlotSharingGroup(jobVertexId1).getSlotSharingGroupId(), (Object)this.getSlotSharingGroup(jobVertexId2).getSlotSharingGroupId());
        }

        private SlotSharingGroup getSlotSharingGroup(JobVertexID jobVertexId) {
            return (SlotSharingGroup)Preconditions.checkNotNull((Object)this.slotSharingGroupMap.get(jobVertexId));
        }

        private void addVertexToExecutionSlotSharingGroup(SchedulingExecutionVertex vertex, ExecutionSlotSharingGroup group) {
            ExecutionVertexID executionVertexId = (ExecutionVertexID)vertex.getId();
            group.addVertex(executionVertexId);
            this.executionSlotSharingGroupMap.put(executionVertexId, group);
            Set availableExecutionSlotSharingGroups = this.availableGroupsForJobVertex.get(executionVertexId.getJobVertexId());
            if (availableExecutionSlotSharingGroups != null) {
                availableExecutionSlotSharingGroups.remove(group);
            }
        }

        private void findAvailableOrCreateNewExecutionSlotSharingGroupFor(List<SchedulingExecutionVertex> executionVertices) {
            for (SchedulingExecutionVertex executionVertex : executionVertices) {
                ExecutionSlotSharingGroup group = this.tryFindAvailableExecutionSlotSharingGroupFor(executionVertex);
                if (group == null) {
                    group = this.createNewExecutionSlotSharingGroup((ExecutionVertexID)executionVertex.getId());
                }
                this.addVertexToExecutionSlotSharingGroup(executionVertex, group);
            }
        }

        private ExecutionSlotSharingGroup tryFindAvailableExecutionSlotSharingGroupFor(SchedulingExecutionVertex executionVertex) {
            Set availableGroupsForCurrentVertex = this.availableGroupsForJobVertex.get(((ExecutionVertexID)executionVertex.getId()).getJobVertexId());
            if (availableGroupsForCurrentVertex != null && !availableGroupsForCurrentVertex.isEmpty()) {
                return (ExecutionSlotSharingGroup)availableGroupsForCurrentVertex.iterator().next();
            }
            return null;
        }

        private ExecutionSlotSharingGroup createNewExecutionSlotSharingGroup(ExecutionVertexID executionVertexId) {
            SlotSharingGroup slotSharingGroup = this.getSlotSharingGroup(executionVertexId.getJobVertexId());
            ExecutionSlotSharingGroup newGroup = new ExecutionSlotSharingGroup(slotSharingGroup);
            for (JobVertexID jobVertexId : slotSharingGroup.getJobVertexIds()) {
                Set availableExecutionSlotSharingGroups = this.availableGroupsForJobVertex.computeIfAbsent(jobVertexId, ignore -> new LinkedHashSet());
                availableExecutionSlotSharingGroups.add(newGroup);
            }
            return newGroup;
        }

        private void updateConstraintToExecutionSlotSharingGroupMap(List<SchedulingExecutionVertex> executionVertices) {
            for (SchedulingExecutionVertex executionVertex : executionVertices) {
                ExecutionVertexID executionVertexId = (ExecutionVertexID)executionVertex.getId();
                CoLocationGroup coLocationGroup = this.coLocationGroupMap.get(executionVertexId.getJobVertexId());
                if (coLocationGroup == null) continue;
                CoLocationConstraint constraint = coLocationGroup.getLocationConstraint(executionVertexId.getSubtaskIndex());
                this.constraintToExecutionSlotSharingGroupMap.put(constraint, this.executionSlotSharingGroupMap.get(executionVertexId));
            }
        }

        private LinkedHashSet<ExecutionSlotSharingGroup> computeAllCandidateGroupsForConsumedPartitionGroup(JobVertexID consumerJobVertexId, ConsumedPartitionGroup consumedPartitionGroup) {
            LinkedHashSet<ExecutionSlotSharingGroup> candidateExecutionSlotSharingGroups = new LinkedHashSet<ExecutionSlotSharingGroup>();
            JobVertexID producerJobVertexId = ((ExecutionVertexID)((SchedulingExecutionVertex)this.topology.getResultPartition(consumedPartitionGroup.getFirst()).getProducer()).getId()).getJobVertexId();
            if (this.inSameLogicalSlotSharingGroup(producerJobVertexId, consumerJobVertexId)) {
                for (IntermediateResultPartitionID consumedPartition : consumedPartitionGroup) {
                    ExecutionVertexID producerExecutionVertexId = (ExecutionVertexID)((SchedulingExecutionVertex)this.topology.getResultPartition(consumedPartition).getProducer()).getId();
                    ExecutionSlotSharingGroup assignedGroupForProducerExecutionVertex = this.executionSlotSharingGroupMap.get(producerExecutionVertexId);
                    Preconditions.checkNotNull((Object)assignedGroupForProducerExecutionVertex);
                    candidateExecutionSlotSharingGroups.add(assignedGroupForProducerExecutionVertex);
                }
            }
            return candidateExecutionSlotSharingGroups;
        }
    }

    static class Factory
    implements SlotSharingStrategy.Factory {
        Factory() {
        }

        @Override
        public LocalInputPreferredSlotSharingStrategy create(SchedulingTopology topology, Set<SlotSharingGroup> logicalSlotSharingGroups, Set<CoLocationGroup> coLocationGroups) {
            return new LocalInputPreferredSlotSharingStrategy(topology, logicalSlotSharingGroups, coLocationGroups);
        }
    }
}

