/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.runtime.event.WatermarkEvent;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributes;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.OutputTag;

public class MockOutput<T>
implements Output<StreamRecord<T>> {
    private Collection<T> outputs;

    public MockOutput(Collection<T> outputs) {
        this.outputs = outputs;
    }

    public void collect(StreamRecord<T> record) {
        try {
            ClassLoader cl = record.getClass().getClassLoader();
            Object copied = InstantiationUtil.deserializeObject((byte[])InstantiationUtil.serializeObject((Object)record.getValue()), (ClassLoader)cl);
            this.outputs.add(copied);
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new RuntimeException("Unable to deserialize record: " + record, ex);
        }
    }

    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        throw new UnsupportedOperationException("Side output not supported for MockOutput");
    }

    public void emitWatermark(Watermark mark) {
        throw new RuntimeException("THIS MUST BE IMPLEMENTED");
    }

    public void emitWatermarkStatus(WatermarkStatus watermarkStatus) {
        throw new RuntimeException("THIS MUST BE IMPLEMENTED");
    }

    public void emitLatencyMarker(LatencyMarker latencyMarker) {
        throw new RuntimeException();
    }

    public void emitRecordAttributes(RecordAttributes recordAttributes) {
        throw new RuntimeException("RecordAttributes is not supported for MockOutput");
    }

    public void emitWatermark(WatermarkEvent watermark) {
        throw new RuntimeException("WatermarkEvent is not supported for MockOutput");
    }

    public void close() {
    }
}

