/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import java.util.ArrayList;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.v2.ListStateDescriptor;
import org.apache.flink.api.common.state.v2.State;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.runtime.asyncprocessing.StateRequestHandler;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.runtime.state.v2.AbstractKeyedStateTestBase;
import org.apache.flink.runtime.state.v2.AbstractListState;
import org.junit.jupiter.api.Test;

public class AbstractListStateTest
extends AbstractKeyedStateTestBase {
    @Test
    public void testEachOperation() {
        ListStateDescriptor descriptor = new ListStateDescriptor("testState", (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        descriptor.initializeSerializerUnlessSet(new ExecutionConfig());
        AbstractListState listState = new AbstractListState((StateRequestHandler)this.aec, descriptor.getSerializer());
        this.aec.setCurrentContext(this.aec.buildContext((Object)"test", (Object)"test"));
        listState.asyncClear();
        this.validateRequestRun((State)listState, StateRequestType.CLEAR, null, 0);
        listState.asyncGet();
        this.validateRequestRun((State)listState, StateRequestType.LIST_GET, null, 0);
        listState.asyncAdd((Object)1);
        this.validateRequestRun((State)listState, StateRequestType.LIST_ADD, 1, 0);
        ArrayList list = new ArrayList();
        listState.asyncUpdate(list);
        this.validateRequestRun((State)listState, StateRequestType.LIST_UPDATE, list, 0);
        list = new ArrayList();
        listState.asyncAddAll(list);
        this.validateRequestRun((State)listState, StateRequestType.LIST_ADD_ALL, list, 0);
        listState.clear();
        this.validateRequestRun((State)listState, StateRequestType.CLEAR, null, 0);
        listState.get().iterator();
        this.validateRequestRun((State)listState, StateRequestType.LIST_GET, null, 0);
        listState.add((Object)1);
        this.validateRequestRun((State)listState, StateRequestType.LIST_ADD, 1, 0);
        list = new ArrayList();
        listState.update(list);
        this.validateRequestRun((State)listState, StateRequestType.LIST_UPDATE, list, 0);
        list = new ArrayList();
        listState.addAll(list);
        this.validateRequestRun((State)listState, StateRequestType.LIST_ADD_ALL, list, 0);
    }
}

