/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.executiongraph.ResultPartitionBytes;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.scheduler.adaptivebatch.PointwiseBlockingResultInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PointwiseBlockingResultInfoTest {
    PointwiseBlockingResultInfoTest() {
    }

    @Test
    void testGetNumBytesProduced() {
        PointwiseBlockingResultInfo resultInfo = new PointwiseBlockingResultInfo(new IntermediateDataSetID(), 2, 2);
        resultInfo.recordPartitionInfo(0, new ResultPartitionBytes(new long[]{32L, 32L}));
        resultInfo.recordPartitionInfo(1, new ResultPartitionBytes(new long[]{64L, 64L}));
        Assertions.assertThat((long)resultInfo.getNumBytesProduced()).isEqualTo(192L);
    }

    @Test
    void testGetNumBytesProducedWithIndexRange() {
        PointwiseBlockingResultInfo resultInfo = new PointwiseBlockingResultInfo(new IntermediateDataSetID(), 2, 2);
        resultInfo.recordPartitionInfo(0, new ResultPartitionBytes(new long[]{32L, 64L}));
        resultInfo.recordPartitionInfo(1, new ResultPartitionBytes(new long[]{128L, 256L}));
        IndexRange partitionIndexRange = new IndexRange(0, 0);
        IndexRange subpartitionIndexRange = new IndexRange(0, 1);
        Assertions.assertThat((long)resultInfo.getNumBytesProduced(partitionIndexRange, subpartitionIndexRange)).isEqualTo(96L);
    }

    @Test
    void testGetBytesWithPartialPartitionInfos() {
        PointwiseBlockingResultInfo resultInfo = new PointwiseBlockingResultInfo(new IntermediateDataSetID(), 2, 2);
        resultInfo.recordPartitionInfo(0, new ResultPartitionBytes(new long[]{32L, 64L}));
        Assertions.assertThatThrownBy(() -> ((PointwiseBlockingResultInfo)resultInfo).getNumBytesProduced()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testPartitionFinishedMultiTimes() {
        PointwiseBlockingResultInfo resultInfo = new PointwiseBlockingResultInfo(new IntermediateDataSetID(), 2, 2);
        resultInfo.recordPartitionInfo(0, new ResultPartitionBytes(new long[]{32L, 64L}));
        resultInfo.recordPartitionInfo(1, new ResultPartitionBytes(new long[]{64L, 128L}));
        Assertions.assertThat((int)resultInfo.getNumOfRecordedPartitions()).isEqualTo(2);
        Assertions.assertThat((long)resultInfo.getNumBytesProduced()).isEqualTo(288L);
        resultInfo.resetPartitionInfo(0);
        Assertions.assertThat((int)resultInfo.getNumOfRecordedPartitions()).isOne();
        resultInfo.recordPartitionInfo(0, new ResultPartitionBytes(new long[]{64L, 128L}));
        Assertions.assertThat((long)resultInfo.getNumBytesProduced()).isEqualTo(384L);
    }
}

