/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.Collection;
import java.util.IntSummaryStatistics;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.runtime.scheduler.adaptive.JobSchedulingPlan;
import org.apache.flink.runtime.scheduler.adaptive.allocator.AbstractSlotMatchingResolverTest;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotMatchingResolver;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotsBalancedSlotMatchingResolver;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.assertj.core.api.Assertions;

class SlotsBalancedSlotMatchingResolverTest
extends AbstractSlotMatchingResolverTest {
    SlotsBalancedSlotMatchingResolverTest() {
    }

    @Override
    protected SlotMatchingResolver createSlotMatchingResolver() {
        return SlotsBalancedSlotMatchingResolver.INSTANCE;
    }

    @Override
    protected void assertAssignments(Collection<JobSchedulingPlan.SlotAssignment> assignments) {
        Map<TaskManagerLocation, Set<JobSchedulingPlan.SlotAssignment>> assignmentsPerTm = SlotsBalancedSlotMatchingResolverTest.getAssignmentsPerTaskManager(assignments);
        IntSummaryStatistics stats = assignmentsPerTm.values().stream().collect(Collectors.summarizingInt(Set::size));
        Assertions.assertThat((int)(stats.getMax() - stats.getMin())).isBetween(Integer.valueOf(0), Integer.valueOf(1));
    }
}

