/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job.metrics;

import java.util.Collection;
import java.util.Collections;
import org.apache.flink.runtime.rest.messages.RestResponseMarshallingTestBase;
import org.apache.flink.runtime.rest.messages.job.metrics.Metric;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricCollectionResponseBody;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.testutils.junit.extensions.parameterized.NoOpTestExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={NoOpTestExtension.class})
class MetricCollectionResponseBodyTest
extends RestResponseMarshallingTestBase<MetricCollectionResponseBody> {
    private static final String TEST_METRIC_NAME = "metric1";
    private static final String TEST_METRIC_VALUE = "1000";

    MetricCollectionResponseBodyTest() {
    }

    @Override
    protected Class<MetricCollectionResponseBody> getTestResponseClass() {
        return MetricCollectionResponseBody.class;
    }

    @Override
    protected MetricCollectionResponseBody getTestResponseInstance() {
        return new MetricCollectionResponseBody(Collections.singleton(new Metric(TEST_METRIC_NAME, TEST_METRIC_VALUE)));
    }

    @Override
    protected void assertOriginalEqualsToUnmarshalled(MetricCollectionResponseBody expected, MetricCollectionResponseBody actual) {
        Assertions.assertThat((Collection)actual.getMetrics()).hasSize(1);
        Metric metric = (Metric)actual.getMetrics().iterator().next();
        Assertions.assertThat((String)metric.getId()).isEqualTo(TEST_METRIC_NAME);
        Assertions.assertThat((String)metric.getValue()).isEqualTo(TEST_METRIC_VALUE);
    }

    @Test
    void testNullValueNotSerialized() throws Exception {
        String json = RestMapperUtils.getStrictObjectMapper().writeValueAsString((Object)new MetricCollectionResponseBody(Collections.singleton(new Metric(TEST_METRIC_NAME))));
        Assertions.assertThat((String)json).doesNotContain(new CharSequence[]{"\"value\""});
        Assertions.assertThat((String)json).doesNotContain(new CharSequence[]{"\"metrics\""});
    }
}

