/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.FreeSlotTracker;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;

public class TestingFreeSlotTracker
implements FreeSlotTracker {
    private final Supplier<Set<AllocationID>> getAvailableSlotsSupplier;
    private final Function<AllocationID, SlotInfo> getSlotInfoFunction;
    private final Supplier<Collection<AllocatedSlotPool.FreeSlotInfo>> getFreeSlotsWithIdleSinceInformationSupplier;
    private final Supplier<Collection<PhysicalSlot>> getFreeSlotsInformationSupplier;
    private final Function<SlotInfo, Double> getTaskExecutorUtilizationFunction;
    private final Consumer<AllocationID> reserveSlotConsumer;
    private final Function<Set<AllocationID>, FreeSlotTracker> createNewFreeSlotTrackerWithoutBlockedSlotsFunction;

    public TestingFreeSlotTracker(Supplier<Set<AllocationID>> getAvailableSlotsSupplier, Function<AllocationID, SlotInfo> getSlotInfoFunction, Supplier<Collection<AllocatedSlotPool.FreeSlotInfo>> getFreeSlotsWithIdleSinceInformationSupplier, Supplier<Collection<PhysicalSlot>> getFreeSlotsInformationSupplier, Function<SlotInfo, Double> getTaskExecutorUtilizationFunction, Consumer<AllocationID> reserveSlotConsumer, Function<Set<AllocationID>, FreeSlotTracker> createNewFreeSlotTrackerWithoutBlockedSlotsFunction) {
        this.getAvailableSlotsSupplier = getAvailableSlotsSupplier;
        this.getSlotInfoFunction = getSlotInfoFunction;
        this.getFreeSlotsWithIdleSinceInformationSupplier = getFreeSlotsWithIdleSinceInformationSupplier;
        this.getFreeSlotsInformationSupplier = getFreeSlotsInformationSupplier;
        this.getTaskExecutorUtilizationFunction = getTaskExecutorUtilizationFunction;
        this.reserveSlotConsumer = reserveSlotConsumer;
        this.createNewFreeSlotTrackerWithoutBlockedSlotsFunction = createNewFreeSlotTrackerWithoutBlockedSlotsFunction;
    }

    public Set<AllocationID> getAvailableSlots() {
        return this.getAvailableSlotsSupplier.get();
    }

    public SlotInfo getSlotInfo(AllocationID allocationId) {
        return this.getSlotInfoFunction.apply(allocationId);
    }

    public Collection<AllocatedSlotPool.FreeSlotInfo> getFreeSlotsWithIdleSinceInformation() {
        return this.getFreeSlotsWithIdleSinceInformationSupplier.get();
    }

    public Collection<PhysicalSlot> getFreeSlotsInformation() {
        return this.getFreeSlotsInformationSupplier.get();
    }

    public double getTaskExecutorUtilization(SlotInfo slotInfo) {
        return this.getTaskExecutorUtilizationFunction.apply(slotInfo);
    }

    public void reserveSlot(AllocationID allocationId) {
        this.reserveSlotConsumer.accept(allocationId);
    }

    public FreeSlotTracker createNewFreeSlotTrackerWithoutBlockedSlots(Set<AllocationID> blockedSlots) {
        return this.createNewFreeSlotTrackerWithoutBlockedSlotsFunction.apply(blockedSlots);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class TestingFreeSlotInfo
    implements AllocatedSlotPool.FreeSlotInfo {
        private final SlotInfo slotInfo;

        public TestingFreeSlotInfo(SlotInfo slotInfo) {
            this.slotInfo = slotInfo;
        }

        public SlotInfo asSlotInfo() {
            return this.slotInfo;
        }

        public long getFreeSince() {
            return 0L;
        }
    }

    public static class Builder {
        private Supplier<Set<AllocationID>> getAvailableSlotsSupplier = Collections::emptySet;
        private Function<AllocationID, SlotInfo> getSlotInfoFunction = ignored -> null;
        private Supplier<Collection<AllocatedSlotPool.FreeSlotInfo>> getFreeSlotsWithIdleSinceInformationSupplier = Collections::emptyList;
        private Supplier<Collection<PhysicalSlot>> getFreeSlotsInformationSupplier = Collections::emptyList;
        private Function<SlotInfo, Double> getTaskExecutorUtilizationFunction = ignored -> 0.0;
        private Consumer<AllocationID> reserveSlotConsumer = ignore -> {};
        private Function<Set<AllocationID>, FreeSlotTracker> createNewFreeSlotTrackerWithoutBlockedSlotsFunction = ignored -> null;

        public Builder setGetAvailableSlotsSupplier(Supplier<Set<AllocationID>> getAvailableSlotsSupplier) {
            this.getAvailableSlotsSupplier = getAvailableSlotsSupplier;
            return this;
        }

        public Builder setGetSlotInfoFunction(Function<AllocationID, SlotInfo> getSlotInfoFunction) {
            this.getSlotInfoFunction = getSlotInfoFunction;
            return this;
        }

        public Builder setGetFreeSlotsWithIdleSinceInformationSupplier(Supplier<Collection<AllocatedSlotPool.FreeSlotInfo>> getFreeSlotsWithIdleSinceInformationSupplier) {
            this.getFreeSlotsWithIdleSinceInformationSupplier = getFreeSlotsWithIdleSinceInformationSupplier;
            return this;
        }

        public Builder setGetFreeSlotsInformationSupplier(Supplier<Collection<PhysicalSlot>> getFreeSlotsInformationSupplier) {
            this.getFreeSlotsInformationSupplier = getFreeSlotsInformationSupplier;
            return this;
        }

        public Builder setGetTaskExecutorUtilizationFunction(Function<SlotInfo, Double> getTaskExecutorUtilizationFunction) {
            this.getTaskExecutorUtilizationFunction = getTaskExecutorUtilizationFunction;
            return this;
        }

        public Builder setReserveSlotConsumer(Consumer<AllocationID> reserveSlotConsumer) {
            this.reserveSlotConsumer = reserveSlotConsumer;
            return this;
        }

        public TestingFreeSlotTracker build() {
            return new TestingFreeSlotTracker(this.getAvailableSlotsSupplier, this.getSlotInfoFunction, this.getFreeSlotsWithIdleSinceInformationSupplier, this.getFreeSlotsInformationSupplier, this.getTaskExecutorUtilizationFunction, this.reserveSlotConsumer, this.createNewFreeSlotTrackerWithoutBlockedSlotsFunction);
        }
    }
}

