/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.disk.BatchShuffleReadBufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferCompressor;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.TieredStorageNettyService;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageConsumerSpec;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemorySpec;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierMasterAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierProducerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleDescriptor;

public class TestingTierFactory
implements TierFactory {
    private Consumer<Configuration> setupConsumer;
    private Supplier<TieredStorageMemorySpec> masterAgentMemorySpecSupplier;
    private Supplier<TieredStorageMemorySpec> producerAgentMemorySpecSupplier;
    private Supplier<TieredStorageMemorySpec> consumerAgentMemorySpecSupplier;
    private Supplier<TierMasterAgent> tierMasterAgentSupplier;
    private Supplier<TierProducerAgent> tierProducerAgentSupplier;
    private BiFunction<List<TieredStorageConsumerSpec>, TieredStorageNettyService, TierConsumerAgent> tierConsumerAgentSupplier;

    private TestingTierFactory(Consumer<Configuration> setupConsumer, Supplier<TieredStorageMemorySpec> masterAgentMemorySpecSupplier, Supplier<TieredStorageMemorySpec> producerAgentMemorySpecSupplier, Supplier<TieredStorageMemorySpec> consumerAgentMemorySpecSupplier, Supplier<TierMasterAgent> tierMasterAgentSupplier, Supplier<TierProducerAgent> tierProducerAgentSupplier, BiFunction<List<TieredStorageConsumerSpec>, TieredStorageNettyService, TierConsumerAgent> tierConsumerAgentSupplier) {
        this.setupConsumer = setupConsumer;
        this.masterAgentMemorySpecSupplier = masterAgentMemorySpecSupplier;
        this.producerAgentMemorySpecSupplier = producerAgentMemorySpecSupplier;
        this.consumerAgentMemorySpecSupplier = consumerAgentMemorySpecSupplier;
        this.tierMasterAgentSupplier = tierMasterAgentSupplier;
        this.tierProducerAgentSupplier = tierProducerAgentSupplier;
        this.tierConsumerAgentSupplier = tierConsumerAgentSupplier;
    }

    public TestingTierFactory() {
    }

    public void setup(Configuration configuration) {
        this.setupConsumer.accept(configuration);
    }

    public TieredStorageMemorySpec getMasterAgentMemorySpec() {
        return this.masterAgentMemorySpecSupplier.get();
    }

    public TieredStorageMemorySpec getProducerAgentMemorySpec() {
        return this.producerAgentMemorySpecSupplier.get();
    }

    public TieredStorageMemorySpec getConsumerAgentMemorySpec() {
        return this.consumerAgentMemorySpecSupplier.get();
    }

    public TierMasterAgent createMasterAgent(TieredStorageResourceRegistry tieredStorageResourceRegistry) {
        return this.tierMasterAgentSupplier.get();
    }

    public TierProducerAgent createProducerAgent(int numPartitions, int numSubpartitions, TieredStoragePartitionId partitionID, String dataFileBasePath, boolean isBroadcastOnly, TieredStorageMemoryManager storageMemoryManager, TieredStorageNettyService nettyService, TieredStorageResourceRegistry resourceRegistry, BatchShuffleReadBufferPool bufferPool, ScheduledExecutorService ioExecutor, List<TierShuffleDescriptor> shuffleDescriptors, int maxRequestedBuffers, @Nullable BufferCompressor bufferCompressor) {
        return this.tierProducerAgentSupplier.get();
    }

    public TierConsumerAgent createConsumerAgent(List<TieredStorageConsumerSpec> tieredStorageConsumerSpecs, List<TierShuffleDescriptor> shuffleDescriptors, TieredStorageNettyService nettyService) {
        return this.tierConsumerAgentSupplier.apply(tieredStorageConsumerSpecs, nettyService);
    }

    public String identifier() {
        return "test";
    }

    public static class Builder {
        private Consumer<Configuration> setupConsumer = conf -> {};
        private Supplier<TieredStorageMemorySpec> masterAgentMemorySpecSupplier = () -> null;
        private Supplier<TieredStorageMemorySpec> producerAgentMemorySpecSupplier = () -> null;
        private Supplier<TieredStorageMemorySpec> consumerAgentMemorySpecSupplier = () -> null;
        private Supplier<TierMasterAgent> tierMasterAgentSupplier = () -> null;
        private Supplier<TierProducerAgent> tierProducerAgentSupplier = () -> null;
        private BiFunction<List<TieredStorageConsumerSpec>, TieredStorageNettyService, TierConsumerAgent> tierConsumerAgentSupplier = (partitionIdAndSubpartitionId, nettyService) -> null;

        public Builder setSetupConsumer(Consumer<Configuration> setupConsumer) {
            this.setupConsumer = setupConsumer;
            return this;
        }

        public Builder setMasterAgentMemorySpecSupplier(Supplier<TieredStorageMemorySpec> masterAgentMemorySpecSupplier) {
            this.masterAgentMemorySpecSupplier = masterAgentMemorySpecSupplier;
            return this;
        }

        public Builder setProducerAgentMemorySpecSupplier(Supplier<TieredStorageMemorySpec> producerAgentMemorySpecSupplier) {
            this.producerAgentMemorySpecSupplier = producerAgentMemorySpecSupplier;
            return this;
        }

        public Builder setConsumerAgentMemorySpecSupplier(Supplier<TieredStorageMemorySpec> consumerAgentMemorySpecSupplier) {
            this.consumerAgentMemorySpecSupplier = consumerAgentMemorySpecSupplier;
            return this;
        }

        public Builder setTierMasterAgentSupplier(Supplier<TierMasterAgent> tierMasterAgentSupplier) {
            this.tierMasterAgentSupplier = tierMasterAgentSupplier;
            return this;
        }

        public Builder setTierProducerAgentSupplier(Supplier<TierProducerAgent> tierProducerAgentSupplier) {
            this.tierProducerAgentSupplier = tierProducerAgentSupplier;
            return this;
        }

        public Builder setTierConsumerAgentSupplier(BiFunction<List<TieredStorageConsumerSpec>, TieredStorageNettyService, TierConsumerAgent> tierConsumerAgentSupplier) {
            this.tierConsumerAgentSupplier = tierConsumerAgentSupplier;
            return this;
        }

        public TestingTierFactory build() {
            return new TestingTierFactory(this.setupConsumer, this.masterAgentMemorySpecSupplier, this.producerAgentMemorySpecSupplier, this.consumerAgentMemorySpecSupplier, this.tierMasterAgentSupplier, this.tierProducerAgentSupplier, this.tierConsumerAgentSupplier);
        }
    }
}

