/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.util.Random;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.event.task.IntegerTaskEvent;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.NettyTestUtil;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.embedded.EmbeddedChannel;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class NettyMessageServerSideSerializationTest {
    private final Random random = new Random();
    private EmbeddedChannel channel;

    NettyMessageServerSideSerializationTest() {
    }

    @BeforeEach
    void setup() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new NettyMessage.NettyMessageEncoder(), new NettyMessage.NettyMessageDecoder()});
    }

    @AfterEach
    void tearDown() {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    @Test
    void testPartitionRequest() {
        int queueIndex = this.random.nextInt(Integer.MAX_VALUE);
        NettyMessage.PartitionRequest expected = new NettyMessage.PartitionRequest(new ResultPartitionID(), new ResultSubpartitionIndexSet(queueIndex), new InputChannelID(), this.random.nextInt());
        NettyMessage.PartitionRequest actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assertions.assertThat((Object)actual.partitionId).isEqualTo((Object)expected.partitionId);
        Assertions.assertThat((Object)actual.queueIndexSet).isEqualTo((Object)expected.queueIndexSet);
        Assertions.assertThat((Comparable)actual.receiverId).isEqualTo((Object)expected.receiverId);
        Assertions.assertThat((int)actual.credit).isEqualTo(expected.credit);
    }

    @Test
    void testTaskEventRequest() {
        NettyMessage.TaskEventRequest expected = new NettyMessage.TaskEventRequest((TaskEvent)new IntegerTaskEvent(this.random.nextInt()), new ResultPartitionID(), new InputChannelID());
        NettyMessage.TaskEventRequest actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assertions.assertThat((Object)actual.event).isEqualTo((Object)expected.event);
        Assertions.assertThat((Object)actual.partitionId).isEqualTo((Object)expected.partitionId);
        Assertions.assertThat((Comparable)actual.receiverId).isEqualTo((Object)expected.receiverId);
    }

    @Test
    void testCancelPartitionRequest() {
        NettyMessage.CancelPartitionRequest expected = new NettyMessage.CancelPartitionRequest(new InputChannelID());
        NettyMessage.CancelPartitionRequest actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assertions.assertThat((Comparable)actual.receiverId).isEqualTo((Object)expected.receiverId);
    }

    @Test
    void testCloseRequest() {
        NettyMessage.CloseRequest expected = new NettyMessage.CloseRequest();
        NettyMessage.CloseRequest actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assertions.assertThat((Object)actual).isExactlyInstanceOf(expected.getClass());
    }

    @Test
    void testAddCredit() {
        NettyMessage.AddCredit expected = new NettyMessage.AddCredit(this.random.nextInt(Integer.MAX_VALUE) + 1, new InputChannelID());
        NettyMessage.AddCredit actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assertions.assertThat((int)actual.credit).isEqualTo(expected.credit);
        Assertions.assertThat((Comparable)actual.receiverId).isEqualTo((Object)expected.receiverId);
    }

    @Test
    void testResumeConsumption() {
        NettyMessage.ResumeConsumption expected = new NettyMessage.ResumeConsumption(new InputChannelID());
        NettyMessage.ResumeConsumption actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assertions.assertThat((Comparable)actual.receiverId).isEqualTo((Object)expected.receiverId);
    }

    @Test
    void testAckAllUserRecordsProcessed() {
        NettyMessage.AckAllUserRecordsProcessed expected = new NettyMessage.AckAllUserRecordsProcessed(new InputChannelID());
        NettyMessage.AckAllUserRecordsProcessed actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assertions.assertThat((Comparable)actual.receiverId).isEqualTo((Object)expected.receiverId);
    }

    @Test
    void testNewBufferSize() {
        NettyMessage.NewBufferSize expected = new NettyMessage.NewBufferSize(this.random.nextInt(Integer.MAX_VALUE), new InputChannelID());
        NettyMessage.NewBufferSize actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assertions.assertThat((int)actual.bufferSize).isEqualTo(expected.bufferSize);
        Assertions.assertThat((Comparable)actual.receiverId).isEqualTo((Object)expected.receiverId);
    }
}

