/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import javax.annotation.Nullable;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.runtime.state.ttl.TtlValue;

public class TtlUtils {
    public static <V> boolean expired(@Nullable TtlValue<V> ttlValue, long ttl, TtlTimeProvider timeProvider) {
        return TtlUtils.expired(ttlValue, ttl, timeProvider.currentTimestamp());
    }

    public static <V> boolean expired(@Nullable TtlValue<V> ttlValue, long ttl, long currentTimestamp) {
        return ttlValue != null && TtlUtils.expired(ttlValue.getLastAccessTimestamp(), ttl, currentTimestamp);
    }

    public static boolean expired(long ts, long ttl, TtlTimeProvider timeProvider) {
        return TtlUtils.expired(ts, ttl, timeProvider.currentTimestamp());
    }

    public static boolean expired(long ts, long ttl, long currentTimestamp) {
        return TtlUtils.getExpirationTimestamp(ts, ttl) <= currentTimestamp;
    }

    private static long getExpirationTimestamp(long ts, long ttl) {
        long ttlWithoutOverflow = ts > 0L ? Math.min(Long.MAX_VALUE - ts, ttl) : ttl;
        return ts + ttlWithoutOverflow;
    }

    public static <V> TtlValue<V> wrapWithTs(V value, long ts) {
        return new TtlValue<V>(value, ts);
    }
}

