/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.runtime.asyncprocessing.declare.DeclarationContext;
import org.apache.flink.runtime.asyncprocessing.declare.DeclaredVariable;
import org.apache.flink.runtime.event.WatermarkEvent;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributes;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.OutputTag;

@Internal
public final class TimestampedCollectorWithDeclaredVariable<T>
implements Output<T> {
    private final Output<StreamRecord<T>> output;
    private final StreamRecord<T> reuse;
    private final DeclaredVariable<Long> timestamp;

    public TimestampedCollectorWithDeclaredVariable(Output<StreamRecord<T>> output, DeclarationContext declarationContext) {
        this(output, declarationContext.declareVariable(LongSerializer.INSTANCE, "_TCollector$timestamp", null));
    }

    public TimestampedCollectorWithDeclaredVariable(Output<StreamRecord<T>> output, DeclaredVariable<Long> timestamp) {
        this.output = output;
        this.timestamp = timestamp;
        this.reuse = new StreamRecord<Object>(null);
    }

    public void collect(T record) {
        Long time = (Long)this.timestamp.get();
        if (time == null) {
            this.reuse.eraseTimestamp();
        } else {
            this.reuse.setTimestamp(time);
        }
        this.output.collect(this.reuse.replace(record));
    }

    public void setTimestamp(StreamRecord<?> timestampBase) {
        if (timestampBase.hasTimestamp()) {
            this.timestamp.set(timestampBase.getTimestamp());
        } else {
            this.timestamp.set(null);
        }
    }

    public void setAbsoluteTimestamp(long time) {
        this.timestamp.set(time);
    }

    public void eraseTimestamp() {
        this.timestamp.set(null);
    }

    public void close() {
        this.output.close();
    }

    @Override
    public void emitWatermark(Watermark mark) {
        this.output.emitWatermark(mark);
    }

    @Override
    public void emitWatermarkStatus(WatermarkStatus watermarkStatus) {
        this.output.emitWatermarkStatus(watermarkStatus);
    }

    @Override
    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        this.output.collect(outputTag, record);
    }

    @Override
    public void emitLatencyMarker(LatencyMarker latencyMarker) {
        this.output.emitLatencyMarker(latencyMarker);
    }

    @Override
    public void emitRecordAttributes(RecordAttributes recordAttributes) {
        this.output.emitRecordAttributes(recordAttributes);
    }

    @Override
    public void emitWatermark(WatermarkEvent watermark) {
        this.output.emitWatermark(watermark);
    }
}

