/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.event.RuntimeEvent;
import org.apache.flink.runtime.event.WatermarkEvent;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributes;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.OutputTag;

public class CollectorOutput<T>
implements Output<StreamRecord<T>> {
    private final List<StreamElement> elementList;
    private final List<RuntimeEvent> eventList;

    public CollectorOutput(List<StreamElement> elementList) {
        this.elementList = elementList;
        this.eventList = new ArrayList<RuntimeEvent>();
    }

    public CollectorOutput(List<StreamElement> elementList, List<RuntimeEvent> eventList) {
        this.elementList = elementList;
        this.eventList = eventList;
    }

    public void emitWatermark(Watermark mark) {
        this.elementList.add((StreamElement)mark);
    }

    public void emitWatermarkStatus(WatermarkStatus watermarkStatus) {
        this.elementList.add((StreamElement)watermarkStatus);
    }

    public void emitLatencyMarker(LatencyMarker latencyMarker) {
        this.elementList.add((StreamElement)latencyMarker);
    }

    public void emitRecordAttributes(RecordAttributes recordAttributes) {
        this.elementList.add((StreamElement)recordAttributes);
    }

    public void emitWatermark(WatermarkEvent watermark) {
        this.eventList.add((RuntimeEvent)watermark);
    }

    public void collect(StreamRecord<T> record) {
        try {
            ClassLoader cl = record.getClass().getClassLoader();
            Object copied = InstantiationUtil.deserializeObject((byte[])InstantiationUtil.serializeObject((Object)record.getValue()), (ClassLoader)cl);
            this.elementList.add((StreamElement)record.copy(copied));
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new RuntimeException("Unable to deserialize record: " + record, ex);
        }
    }

    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        throw new UnsupportedOperationException("Side output not supported for CollectorOutput");
    }

    public void close() {
    }
}

