/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.DefaultOperatorStateBackend;
import org.apache.flink.runtime.state.InternalKeyContext;
import org.apache.flink.runtime.state.InternalKeyContextImpl;
import org.apache.flink.runtime.state.KeyGroupedInternalPriorityQueue;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.PriorityComparable;
import org.apache.flink.runtime.state.SavepointResources;
import org.apache.flink.runtime.state.SnapshotExecutionType;
import org.apache.flink.runtime.state.SnapshotResources;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.SnapshotStrategy;
import org.apache.flink.runtime.state.SnapshotStrategyRunner;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueElement;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.SizeTrackingStateConfig;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;

public class TestStateBackend
extends AbstractStateBackend {
    private static final long serialVersionUID = 1L;

    public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(StateBackend.KeyedStateBackendParameters<K> parameters) throws IOException {
        return new TestKeyedStateBackend(parameters.getKvStateRegistry(), parameters.getKeySerializer(), Thread.currentThread().getContextClassLoader(), parameters.getEnv().getExecutionConfig(), parameters.getTtlTimeProvider(), LatencyTrackingStateConfig.newBuilder().build(), SizeTrackingStateConfig.newBuilder().build(), parameters.getCancelStreamRegistry(), new InternalKeyContextImpl(parameters.getKeyGroupRange(), parameters.getNumberOfKeyGroups()));
    }

    public OperatorStateBackend createOperatorStateBackend(StateBackend.OperatorStateBackendParameters parameters) throws Exception {
        return new DefaultOperatorStateBackend(parameters.getEnv().getExecutionConfig(), parameters.getCancelStreamRegistry(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), new SnapshotStrategyRunner("Async Failure State Backend", (SnapshotStrategy)new SnapshotStrategy<OperatorStateHandle, SnapshotResources>(){

            public SnapshotResources syncPrepareResources(long checkpointId) {
                return null;
            }

            public SnapshotStrategy.SnapshotResultSupplier<OperatorStateHandle> asyncSnapshot(SnapshotResources syncPartResource, long checkpointId, long timestamp, @Nonnull CheckpointStreamFactory streamFactory, @Nonnull CheckpointOptions checkpointOptions) {
                return null;
            }
        }, new CloseableRegistry(), SnapshotExecutionType.ASYNCHRONOUS));
    }

    static class TestKeyedStateBackend<K>
    extends AbstractKeyedStateBackend<K> {
        private long subsumeCheckpointId = -1L;

        public TestKeyedStateBackend(TaskKvStateRegistry kvStateRegistry, TypeSerializer<K> keySerializer, ClassLoader userCodeClassLoader, ExecutionConfig executionConfig, TtlTimeProvider ttlTimeProvider, LatencyTrackingStateConfig latencyTrackingStateConfig, SizeTrackingStateConfig sizeTrackingStateConfig, CloseableRegistry cancelStreamRegistry, InternalKeyContext<K> keyContext) {
            super(kvStateRegistry, keySerializer, userCodeClassLoader, executionConfig, ttlTimeProvider, latencyTrackingStateConfig, sizeTrackingStateConfig, cancelStreamRegistry, keyContext);
        }

        public void notifyCheckpointComplete(long checkpointId) {
        }

        public void notifyCheckpointSubsumed(long checkpointId) {
            this.subsumeCheckpointId = checkpointId;
        }

        public long getSubsumeCheckpointId() {
            return this.subsumeCheckpointId;
        }

        @Nonnull
        public SavepointResources<K> savepoint() throws Exception {
            throw new UnsupportedOperationException();
        }

        public <N> Stream<K> getKeys(String state, N namespace) {
            throw new UnsupportedOperationException();
        }

        public <N> Stream<K> getKeys(List<String> states, N namespace) {
            throw new UnsupportedOperationException();
        }

        public <N> Stream<Tuple2<K, N>> getKeysAndNamespaces(String state) {
            throw new UnsupportedOperationException();
        }

        public String getBackendTypeIdentifier() {
            return "test";
        }

        @Nonnull
        public <N, SV, SEV, S extends State, IS extends S> IS createOrUpdateInternalState(@Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull StateDescriptor<S, SV> stateDesc, @Nonnull StateSnapshotTransformer.StateSnapshotTransformFactory<SEV> snapshotTransformFactory) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        public <T extends HeapPriorityQueueElement & PriorityComparable<? super T>> KeyGroupedInternalPriorityQueue<T> create(@Nonnull String stateName, @Nonnull TypeSerializer<T> byteOrderedElementSerializer) {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        public RunnableFuture<SnapshotResult<KeyedStateHandle>> snapshot(long checkpointId, long timestamp, @Nonnull CheckpointStreamFactory streamFactory, @Nonnull CheckpointOptions checkpointOptions) throws Exception {
            return new FutureTask<SnapshotResult<KeyedStateHandle>>(SnapshotResult::empty);
        }

        public int numKeyValueStateEntries() {
            return 0;
        }
    }
}

