/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.io.Serializable;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.flink.api.common.eventtime.SerializableTimestampAssigner;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.connector.source.mocks.MockSourceSplit;
import org.apache.flink.streaming.api.operators.SourceOperator;
import org.apache.flink.streaming.api.operators.SourceOperatorAlignmentTest;
import org.apache.flink.streaming.api.operators.SourceOperatorTestContext;
import org.apache.flink.streaming.api.operators.source.CollectingDataOutput;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.DataInputStatus;
import org.apache.flink.streaming.util.MockOutput;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SourceOperatorWatermarksTest {
    @Nullable
    private SourceOperatorTestContext context;
    @Nullable
    private SourceOperator<Integer, MockSourceSplit> operator;

    SourceOperatorWatermarksTest() {
    }

    @BeforeEach
    void setup() throws Exception {
        this.context = new SourceOperatorTestContext(false, true, (WatermarkStrategy<Integer>)WatermarkStrategy.forGenerator((WatermarkGeneratorSupplier & Serializable)ctx -> new SourceOperatorAlignmentTest.PunctuatedGenerator()).withTimestampAssigner((SerializableTimestampAssigner & Serializable)(r, t) -> r.intValue()), new MockOutput<Integer>(new ArrayList()));
        this.operator = this.context.getOperator();
    }

    @AfterEach
    void tearDown() throws Exception {
        this.context.close();
        this.context = null;
        this.operator = null;
    }

    @Test
    void testPerPartitionWatermarksAfterRecovery() throws Exception {
        ArrayList<MockSourceSplit> initialSplits = new ArrayList<MockSourceSplit>();
        initialSplits.add(new MockSourceSplit(0).addRecord(1042).addRecord(1044));
        initialSplits.add(new MockSourceSplit(1).addRecord(42).addRecord(44));
        this.operator.initializeState(this.context.createStateContext(initialSplits));
        this.operator.open();
        CollectingDataOutput<Integer> actualOutput = new CollectingDataOutput<Integer>();
        Assertions.assertThat((Comparable)this.operator.emitNext(actualOutput)).isEqualTo((Object)DataInputStatus.MORE_AVAILABLE);
        SourceOperatorWatermarksTest.assertNoWatermarks(actualOutput);
        Assertions.assertThat((Comparable)this.operator.emitNext(actualOutput)).isEqualTo((Object)DataInputStatus.MORE_AVAILABLE);
        Assertions.assertThat((Comparable)this.operator.emitNext(actualOutput)).isEqualTo((Object)DataInputStatus.MORE_AVAILABLE);
        this.assertWatermark(actualOutput, new Watermark(42L));
    }

    private static void assertNoWatermarks(CollectingDataOutput<Integer> actualOutput) {
        Assertions.assertThat(actualOutput.getEvents()).noneMatch(element -> element instanceof Watermark);
    }

    private void assertWatermark(CollectingDataOutput<Integer> actualOutput, Watermark watermark) {
        Assertions.assertThat(actualOutput.getEvents()).containsOnlyOnce(new Object[]{watermark});
    }
}

