/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.mocks.MockSourceSplit;
import org.apache.flink.runtime.io.AvailabilityProvider;
import org.apache.flink.streaming.api.operators.SourceOperator;
import org.apache.flink.streaming.api.operators.SourceOperatorTestContext;
import org.apache.flink.streaming.api.operators.source.CollectingDataOutput;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SourceOperatorIdleTest {
    @Nullable
    private SourceOperatorTestContext context;
    @Nullable
    private SourceOperator<Integer, MockSourceSplit> operator;

    SourceOperatorIdleTest() {
    }

    @BeforeEach
    void setup() throws Exception {
        this.context = new SourceOperatorTestContext();
        this.operator = this.context.getOperator();
    }

    @AfterEach
    void tearDown() throws Exception {
        this.context.close();
        this.context = null;
        this.operator = null;
    }

    @Test
    void testSameAvailabilityFuture() throws Exception {
        this.operator.initializeState(this.context.createStateContext());
        this.operator.open();
        this.operator.emitNext(new CollectingDataOutput());
        CompletableFuture initialFuture = this.operator.getAvailableFuture();
        Assertions.assertThat((CompletableFuture)initialFuture).isNotDone();
        CompletableFuture secondFuture = this.operator.getAvailableFuture();
        Assertions.assertThat((CompletableFuture)initialFuture).isNotSameAs((Object)AvailabilityProvider.AVAILABLE);
        Assertions.assertThat((CompletableFuture)secondFuture).isSameAs((Object)initialFuture);
    }
}

