/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.taskexecutor.JobLeaderListener;
import org.apache.flink.runtime.taskexecutor.JobLeaderService;
import org.apache.flink.util.function.BiConsumerWithException;
import org.apache.flink.util.function.QuadConsumer;
import org.apache.flink.util.function.ThrowingRunnable;

public class TestingJobLeaderService
implements JobLeaderService {
    private final QuadConsumer<String, RpcService, HighAvailabilityServices, JobLeaderListener> startConsumer;
    private final ThrowingRunnable<? extends Exception> stopRunnable;
    private final Consumer<JobID> removeJobConsumer;
    private final BiConsumerWithException<JobID, String, ? extends Exception> addJobConsumer;
    private final Consumer<JobID> reconnectConsumer;
    private final Function<JobID, Boolean> containsJobFunction;

    TestingJobLeaderService(QuadConsumer<String, RpcService, HighAvailabilityServices, JobLeaderListener> startConsumer, ThrowingRunnable<? extends Exception> stopRunnable, Consumer<JobID> removeJobConsumer, BiConsumerWithException<JobID, String, ? extends Exception> addJobConsumer, Consumer<JobID> reconnectConsumer, Function<JobID, Boolean> containsJobFunction) {
        this.startConsumer = startConsumer;
        this.stopRunnable = stopRunnable;
        this.removeJobConsumer = removeJobConsumer;
        this.addJobConsumer = addJobConsumer;
        this.reconnectConsumer = reconnectConsumer;
        this.containsJobFunction = containsJobFunction;
    }

    public void start(String initialOwnerAddress, RpcService initialRpcService, HighAvailabilityServices initialHighAvailabilityServices, JobLeaderListener initialJobLeaderListener) {
        this.startConsumer.accept((Object)initialOwnerAddress, (Object)initialRpcService, (Object)initialHighAvailabilityServices, (Object)initialJobLeaderListener);
    }

    public void stop() throws Exception {
        this.stopRunnable.run();
    }

    public void removeJob(JobID jobId) {
        this.removeJobConsumer.accept(jobId);
    }

    public void addJob(JobID jobId, String defaultTargetAddress) throws Exception {
        this.addJobConsumer.accept((Object)jobId, (Object)defaultTargetAddress);
    }

    public void reconnect(JobID jobId) {
        this.reconnectConsumer.accept(jobId);
    }

    public boolean containsJob(JobID jobId) {
        return this.containsJobFunction.apply(jobId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private QuadConsumer<String, RpcService, HighAvailabilityServices, JobLeaderListener> startConsumer = (ignoredA, ignoredB, ignoredC, ignoredD) -> {};
        private ThrowingRunnable<? extends Exception> stopRunnable = () -> {};
        private Consumer<JobID> removeJobConsumer = ignored -> {};
        private BiConsumerWithException<JobID, String, ? extends Exception> addJobConsumer = (ignoredA, ignoredB) -> {};
        private Consumer<JobID> reconnectConsumer = ignored -> {};
        private Function<JobID, Boolean> containsJobFunction = ignored -> false;

        private Builder() {
        }

        public Builder setStartConsumer(QuadConsumer<String, RpcService, HighAvailabilityServices, JobLeaderListener> startConsumer) {
            this.startConsumer = startConsumer;
            return this;
        }

        public Builder setStopRunnable(ThrowingRunnable<? extends Exception> stopRunnable) {
            this.stopRunnable = stopRunnable;
            return this;
        }

        public Builder setRemoveJobConsumer(Consumer<JobID> removeJobConsumer) {
            this.removeJobConsumer = removeJobConsumer;
            return this;
        }

        public Builder setAddJobConsumer(BiConsumerWithException<JobID, String, ? extends Exception> addJobConsumer) {
            this.addJobConsumer = addJobConsumer;
            return this;
        }

        public Builder setReconnectConsumer(Consumer<JobID> reconnectConsumer) {
            this.reconnectConsumer = reconnectConsumer;
            return this;
        }

        public Builder setContainsJobFunction(Function<JobID, Boolean> containsJobFunction) {
            this.containsJobFunction = containsJobFunction;
            return this;
        }

        public TestingJobLeaderService build() {
            return new TestingJobLeaderService(this.startConsumer, this.stopRunnable, this.removeJobConsumer, this.addJobConsumer, this.reconnectConsumer, this.containsJobFunction);
        }
    }
}

