/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Queue;
import java.util.stream.Stream;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.taskexecutor.SystemOutRedirectionUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

class SystemOutRedirectionUtilsTest {
    private PrintStream originalOut;
    private PrintStream originalErr;
    private Queue<String> outCollector;
    private Queue<String> errCollector;

    SystemOutRedirectionUtilsTest() {
    }

    static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{TaskManagerOptions.SystemOutMode.LOG, SystemOutRedirectionUtils.OUT_TO_LOG_TIPS, SystemOutRedirectionUtils.ERR_TO_LOG_TIPS}), Arguments.of((Object[])new Object[]{TaskManagerOptions.SystemOutMode.IGNORE, SystemOutRedirectionUtils.OUT_IGNORE_TIPS, SystemOutRedirectionUtils.ERR_IGNORE_TIPS}));
    }

    @BeforeEach
    void beforeEach() {
        this.originalOut = System.out;
        this.originalErr = System.err;
        this.outCollector = new LinkedList<String>();
        this.errCollector = new LinkedList<String>();
    }

    @AfterEach
    void afterEach() {
        System.setOut(this.originalOut);
        System.setErr(this.originalErr);
    }

    @Test
    void testDefaultSystemOutAndErr() {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errStream = new ByteArrayOutputStream();
        System.setOut(new PrintStream(outStream));
        System.setErr(new PrintStream(errStream));
        SystemOutRedirectionUtils.redirectSystemOutAndError((Configuration)new Configuration());
        String logContext = "This is log context!";
        System.out.print(logContext);
        Assertions.assertThat((String)outStream.toString()).isEqualTo(logContext);
        System.err.print(logContext);
        Assertions.assertThat((String)errStream.toString()).isEqualTo(logContext);
    }

    @ParameterizedTest(name="systemOutMode = {0}, outTips = {1}, errTips = {2}")
    @MethodSource(value={"parameters"})
    void testSystemOutAndErrAreRedirected(TaskManagerOptions.SystemOutMode systemOutMode, String outTips, String errTips) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errStream = new ByteArrayOutputStream();
        System.setOut(new PrintStream(outStream));
        System.setErr(new PrintStream(errStream));
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TASK_MANAGER_SYSTEM_OUT_MODE, (Object)systemOutMode);
        SystemOutRedirectionUtils.redirectSystemOutAndError((Configuration)conf);
        String logContext = "This is log context!";
        System.out.print(logContext);
        Assertions.assertThat((String)outStream.toString()).isEqualTo(outTips);
        System.err.print(logContext);
        Assertions.assertThat((String)errStream.toString()).isEqualTo(errTips);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void testLogThreadName(boolean logThreadName) {
        SystemOutRedirectionUtils.redirectToLoggingRedirector(this.outCollector::add, this.errCollector::add, (long)100000L, (boolean)logThreadName);
        String logContext = "This is" + System.lineSeparator() + " log context!";
        System.out.println(logContext);
        System.err.println(logContext);
        Assertions.assertThat((String)this.outCollector.poll()).isEqualTo(this.generateExpectedContext(logContext, logThreadName));
        Assertions.assertThat((String)this.errCollector.poll()).isEqualTo(this.generateExpectedContext(logContext, logThreadName));
        String part1 = "Log " + System.lineSeparator() + "context part 1.";
        String part2 = "Log context part 2.";
        System.out.print(part1);
        System.err.print(part1);
        Assertions.assertThat(this.outCollector).isEmpty();
        Assertions.assertThat(this.errCollector).isEmpty();
        System.out.println(part2);
        System.err.println(part2);
        Assertions.assertThat((String)this.outCollector.poll()).isEqualTo(this.generateExpectedContext(part1 + part2, logThreadName));
        Assertions.assertThat((String)this.errCollector.poll()).isEqualTo(this.generateExpectedContext(part1 + part2, logThreadName));
        System.out.print(part1);
        System.err.print(part1);
        Assertions.assertThat(this.outCollector).isEmpty();
        Assertions.assertThat(this.errCollector).isEmpty();
        System.out.print(System.lineSeparator());
        System.err.print(System.lineSeparator());
        Assertions.assertThat((String)this.outCollector.poll()).isEqualTo(this.generateExpectedContext(part1, logThreadName));
        Assertions.assertThat((String)this.errCollector.poll()).isEqualTo(this.generateExpectedContext(part1, logThreadName));
    }

    private String generateExpectedContext(String originalLogContext, boolean logThreadName) {
        if (!logThreadName) {
            return originalLogContext;
        }
        return String.format("Thread Name: %s , log context: %s", Thread.currentThread().getName(), originalLogContext);
    }

    @Test
    void testByteLimitEachLine() {
        int byteLimitEachLine = 100;
        SystemOutRedirectionUtils.redirectToLoggingRedirector(this.outCollector::add, this.errCollector::add, (long)byteLimitEachLine, (boolean)false);
        StringBuilder expectedContext = new StringBuilder();
        for (int i = 0; i < byteLimitEachLine; ++i) {
            Assertions.assertThat(this.outCollector).isEmpty();
            Assertions.assertThat(this.errCollector).isEmpty();
            System.out.print('a');
            System.err.print('a');
            expectedContext.append('a');
        }
        Assertions.assertThat((String)this.outCollector.poll()).isEqualTo(expectedContext.toString());
    }
}

