/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.metrics.MetricsTrackingStateTestBase;
import org.apache.flink.runtime.state.metrics.MetricsTrackingValueState;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MetricsTrackingValueStateTest
extends MetricsTrackingStateTestBase<Integer> {
    MetricsTrackingValueStateTest() {
    }

    ValueStateDescriptor<Long> getStateDescriptor() {
        return new ValueStateDescriptor("value", Long.class);
    }

    IntSerializer getKeySerializer() {
        return IntSerializer.INSTANCE;
    }

    @Override
    void setCurrentKey(AbstractKeyedStateBackend<Integer> keyedBackend) {
        keyedBackend.setCurrentKey((Object)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testLatencyTrackingValueState() throws Exception {
        AbstractKeyedStateBackend keyedBackend = this.createKeyedBackend(this.getKeySerializer());
        try {
            MetricsTrackingValueState latencyTrackingState = (MetricsTrackingValueState)this.createMetricsTrackingState(keyedBackend, this.getStateDescriptor());
            latencyTrackingState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            MetricsTrackingValueState.ValueStateMetrics latencyTrackingStateMetric = (MetricsTrackingValueState.ValueStateMetrics)latencyTrackingState.getLatencyTrackingStateMetric();
            Assertions.assertThat((int)latencyTrackingStateMetric.getUpdateCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getGetCount()).isZero();
            this.setCurrentKey((AbstractKeyedStateBackend<Integer>)keyedBackend);
            for (int index = 1; index <= 10; ++index) {
                int expectedResult = index == 10 ? 0 : index;
                latencyTrackingState.update((Object)ThreadLocalRandom.current().nextLong());
                Assertions.assertThat((int)latencyTrackingStateMetric.getUpdateCount()).isEqualTo(expectedResult);
                latencyTrackingState.value();
                Assertions.assertThat((int)latencyTrackingStateMetric.getGetCount()).isEqualTo(expectedResult);
            }
        }
        finally {
            if (keyedBackend != null) {
                keyedBackend.close();
                keyedBackend.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSizeTrackingValueState() throws Exception {
        AbstractKeyedStateBackend keyedBackend = this.createKeyedBackend(this.getKeySerializer());
        try {
            MetricsTrackingValueState sizeTrackingState = (MetricsTrackingValueState)this.createMetricsTrackingState(keyedBackend, this.getStateDescriptor());
            sizeTrackingState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            MetricsTrackingValueState.ValueStateMetrics sizeTrackingStateMetric = (MetricsTrackingValueState.ValueStateMetrics)sizeTrackingState.getSizeTrackingStateMetric();
            Assertions.assertThat((int)sizeTrackingStateMetric.getUpdateCount()).isZero();
            Assertions.assertThat((int)sizeTrackingStateMetric.getGetCount()).isZero();
            this.setCurrentKey((AbstractKeyedStateBackend<Integer>)keyedBackend);
            for (int index = 1; index <= 10; ++index) {
                int expectedResult = index == 10 ? 0 : index;
                sizeTrackingState.update((Object)ThreadLocalRandom.current().nextLong());
                Assertions.assertThat((int)sizeTrackingStateMetric.getUpdateCount()).isEqualTo(expectedResult);
                sizeTrackingState.value();
                Assertions.assertThat((int)sizeTrackingStateMetric.getGetCount()).isEqualTo(expectedResult);
            }
        }
        finally {
            if (keyedBackend != null) {
                keyedBackend.close();
                keyedBackend.dispose();
            }
        }
    }
}

