/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.core.fs.ICloseableRegistry;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.PathsCopyingFileSystem;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStateToolset;
import org.apache.flink.runtime.state.filesystem.RelativeFileStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.testutils.TestFileSystem;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FsCheckpointStateToolsetTest {
    FsCheckpointStateToolsetTest() {
    }

    @Test
    void testCanDuplicateNonFileStreamHandle() throws IOException {
        FsCheckpointStateToolset stateToolset = new FsCheckpointStateToolset(new Path("test-path"), (PathsCopyingFileSystem)new TestDuplicatingFileSystem());
        boolean canFastDuplicate = stateToolset.canFastDuplicate((StreamStateHandle)new ByteStreamStateHandle("test", new byte[0]));
        Assertions.assertThat((boolean)canFastDuplicate).isFalse();
    }

    @Test
    void testCanDuplicate() throws IOException {
        FsCheckpointStateToolset stateToolset = new FsCheckpointStateToolset(new Path("test-path"), (PathsCopyingFileSystem)new TestDuplicatingFileSystem());
        boolean canFastDuplicate = stateToolset.canFastDuplicate((StreamStateHandle)new FileStateHandle(new Path("old-test-path", "test-file"), 0L));
        Assertions.assertThat((boolean)canFastDuplicate).isTrue();
    }

    @Test
    void testCannotDuplicate() throws IOException {
        FsCheckpointStateToolset stateToolset = new FsCheckpointStateToolset(new Path("test-path"), (PathsCopyingFileSystem)new TestDuplicatingFileSystem());
        boolean canFastDuplicate = stateToolset.canFastDuplicate((StreamStateHandle)new FileStateHandle(new Path("test-path", "test-file"), 0L));
        Assertions.assertThat((boolean)canFastDuplicate).isFalse();
    }

    @Test
    void testDuplicating() throws IOException {
        TestDuplicatingFileSystem fs = new TestDuplicatingFileSystem();
        FsCheckpointStateToolset stateToolset = new FsCheckpointStateToolset(new Path("test-path"), (PathsCopyingFileSystem)fs);
        List duplicated = stateToolset.duplicate(Arrays.asList(new FileStateHandle(new Path("old-test-path", "test-file1"), 0L), new FileStateHandle(new Path("old-test-path", "test-file2"), 0L), new RelativeFileStateHandle(new Path("old-test-path", "test-file3"), "test-file3", 0L)));
        Assertions.assertThat((List)duplicated).containsExactly((Object[])new StreamStateHandle[]{new FileStateHandle(new Path("test-path", "test-file1"), 0L), new FileStateHandle(new Path("test-path", "test-file2"), 0L), new RelativeFileStateHandle(new Path("test-path", "test-file3"), "test-file3", 0L)});
    }

    private static final class TestDuplicatingFileSystem
    extends TestFileSystem
    implements PathsCopyingFileSystem {
        private TestDuplicatingFileSystem() {
        }

        public boolean canCopyPaths(Path source, Path destination) throws IOException {
            return !source.equals((Object)destination);
        }

        public void copyFiles(List<PathsCopyingFileSystem.CopyRequest> requests, ICloseableRegistry closeableRegistry) throws IOException {
        }
    }
}

