/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.TaskExecutorFileMergingManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TaskExecutorFileMergingManagerTest {
    @Test
    public void testCheckpointScope(@TempDir java.nio.file.Path testBaseDir) throws IOException {
        ResourceID tmResourceId1 = ResourceID.generate();
        ResourceID tmResourceId2 = ResourceID.generate();
        ResourceID tmResourceId3 = ResourceID.generate();
        ResourceID tmResourceId4 = ResourceID.generate();
        TaskExecutorFileMergingManager taskExecutorFileMergingManager = new TaskExecutorFileMergingManager();
        JobID job1 = new JobID(1234L, 4321L);
        JobID job2 = new JobID(1234L, 5678L);
        FileMergingSnapshotManager.SubtaskKey key1 = new FileMergingSnapshotManager.SubtaskKey("test-jobId", "test-op1", 0, 128);
        FileMergingSnapshotManager.SubtaskKey key2 = new FileMergingSnapshotManager.SubtaskKey("test-jobId", "test-op2", 1, 128);
        Path checkpointDir1 = new Path(testBaseDir.toString(), "job1");
        Path checkpointDir2 = new Path(testBaseDir.toString(), "job2");
        int writeBufferSize = 4096;
        Configuration jobConfig = new Configuration();
        jobConfig.set(CheckpointingOptions.FILE_MERGING_ENABLED, (Object)true);
        Configuration clusterConfig = new Configuration();
        ExecutionAttemptID executionID1 = ExecutionAttemptID.randomId();
        FileMergingSnapshotManager manager1 = taskExecutorFileMergingManager.fileMergingSnapshotManagerForTask(job1, tmResourceId1, executionID1, clusterConfig, jobConfig, (TaskManagerJobMetricGroup)new UnregisteredMetricGroups.UnregisteredTaskManagerJobMetricGroup());
        manager1.initFileSystem(checkpointDir1.getFileSystem(), checkpointDir1, new Path(checkpointDir1, "shared"), new Path(checkpointDir1, "taskowned"), writeBufferSize);
        ExecutionAttemptID executionID2 = ExecutionAttemptID.randomId();
        FileMergingSnapshotManager manager2 = taskExecutorFileMergingManager.fileMergingSnapshotManagerForTask(job1, tmResourceId2, executionID2, clusterConfig, jobConfig, (TaskManagerJobMetricGroup)new UnregisteredMetricGroups.UnregisteredTaskManagerJobMetricGroup());
        manager2.initFileSystem(checkpointDir1.getFileSystem(), checkpointDir1, new Path(checkpointDir1, "shared"), new Path(checkpointDir1, "taskowned"), writeBufferSize);
        ExecutionAttemptID executionID3 = ExecutionAttemptID.randomId();
        FileMergingSnapshotManager manager3 = taskExecutorFileMergingManager.fileMergingSnapshotManagerForTask(job2, tmResourceId3, executionID3, clusterConfig, jobConfig, (TaskManagerJobMetricGroup)new UnregisteredMetricGroups.UnregisteredTaskManagerJobMetricGroup());
        manager3.initFileSystem(checkpointDir2.getFileSystem(), checkpointDir2, new Path(checkpointDir2, "shared"), new Path(checkpointDir2, "taskowned"), writeBufferSize);
        Assertions.assertThat((Object)manager1).isEqualTo((Object)manager2);
        Assertions.assertThat((Object)manager1).isNotEqualTo((Object)manager3);
        Assertions.assertThat((Object)manager1.getManagedDir(key1, CheckpointedStateScope.EXCLUSIVE)).isEqualTo((Object)manager2.getManagedDir(key2, CheckpointedStateScope.EXCLUSIVE));
        Assertions.assertThat((Object)manager1.getManagedDir(key1, CheckpointedStateScope.EXCLUSIVE)).isNotEqualTo((Object)manager3.getManagedDir(key2, CheckpointedStateScope.EXCLUSIVE));
        manager1.registerSubtaskForSharedStates(key1);
        manager1.registerSubtaskForSharedStates(key2);
        manager3.registerSubtaskForSharedStates(key1);
        manager3.registerSubtaskForSharedStates(key2);
        Assertions.assertThat((Object)manager1.getManagedDir(key1, CheckpointedStateScope.SHARED)).isNotEqualTo((Object)manager1.getManagedDir(key2, CheckpointedStateScope.SHARED));
        Assertions.assertThat((Object)manager1.getManagedDir(key1, CheckpointedStateScope.SHARED)).isNotEqualTo((Object)manager3.getManagedDir(key1, CheckpointedStateScope.SHARED));
        taskExecutorFileMergingManager.releaseMergingSnapshotManagerForTask(job1, executionID1);
        taskExecutorFileMergingManager.releaseMergingSnapshotManagerForTask(job1, executionID2);
        taskExecutorFileMergingManager.releaseMergingSnapshotManagerForTask(job2, executionID3);
        ExecutionAttemptID executionID4 = ExecutionAttemptID.randomId();
        FileMergingSnapshotManager manager4 = taskExecutorFileMergingManager.fileMergingSnapshotManagerForTask(job1, tmResourceId4, executionID4, clusterConfig, jobConfig, (TaskManagerJobMetricGroup)new UnregisteredMetricGroups.UnregisteredTaskManagerJobMetricGroup());
        Assertions.assertThat((Object)manager4).isNotEqualTo((Object)manager1);
    }
}

