/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.failure.FailureEnricherUtils;
import org.apache.flink.runtime.scheduler.exceptionhistory.ArchivedTaskManagerLocationMatcher;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.scheduler.exceptionhistory.TestingAccessExecution;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ExceptionHistoryEntryTest {
    ExceptionHistoryEntryTest() {
    }

    @Test
    void testCreate() {
        RuntimeException failure = new RuntimeException("Expected exception");
        long timestamp = System.currentTimeMillis();
        LocalTaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
        TestingAccessExecution execution = TestingAccessExecution.newBuilder().withErrorInfo(new ErrorInfo((Throwable)failure, timestamp)).withTaskManagerLocation(taskManagerLocation).build();
        String taskName = "task name";
        Map<String, String> failureLabels = Collections.singletonMap("key", "value");
        ExceptionHistoryEntry entry = ExceptionHistoryEntry.create((AccessExecution)execution, (String)"task name", CompletableFuture.completedFuture(failureLabels));
        Assertions.assertThat((Throwable)entry.getException().deserializeError(ClassLoader.getSystemClassLoader())).isEqualTo((Object)failure);
        Assertions.assertThat((long)entry.getTimestamp()).isEqualTo(timestamp);
        Assertions.assertThat((String)entry.getFailingTaskName()).isEqualTo("task name");
        Assertions.assertThat((Object)entry.getTaskManagerLocation()).matches(ArchivedTaskManagerLocationMatcher.isArchivedTaskManagerLocation(taskManagerLocation));
        Assertions.assertThat((boolean)entry.isGlobal()).isFalse();
        Assertions.assertThat((Map)entry.getFailureLabels()).isEqualTo(failureLabels);
    }

    @Test
    void testCreationFailure() {
        Assertions.assertThatThrownBy(() -> ExceptionHistoryEntry.create((AccessExecution)TestingAccessExecution.newBuilder().withTaskManagerLocation(new LocalTaskManagerLocation()).build(), (String)"task name", (CompletableFuture)FailureEnricherUtils.EMPTY_FAILURE_LABELS)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testNullExecution() {
        Assertions.assertThatThrownBy(() -> ExceptionHistoryEntry.create(null, (String)"task name", (CompletableFuture)FailureEnricherUtils.EMPTY_FAILURE_LABELS)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testNullTaskName() {
        Assertions.assertThatThrownBy(() -> ExceptionHistoryEntry.create((AccessExecution)TestingAccessExecution.newBuilder().withErrorInfo(new ErrorInfo((Throwable)new Exception("Expected failure"), System.currentTimeMillis())).withTaskManagerLocation(new LocalTaskManagerLocation()).build(), null, (CompletableFuture)FailureEnricherUtils.EMPTY_FAILURE_LABELS)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testWithMissingTaskManagerLocation() {
        Exception failure = new Exception("Expected failure");
        long timestamp = System.currentTimeMillis();
        String taskName = "task name";
        ExceptionHistoryEntry entry = ExceptionHistoryEntry.create((AccessExecution)TestingAccessExecution.newBuilder().withTaskManagerLocation(null).withErrorInfo(new ErrorInfo((Throwable)failure, timestamp)).build(), (String)"task name", (CompletableFuture)FailureEnricherUtils.EMPTY_FAILURE_LABELS);
        Assertions.assertThat((Throwable)entry.getException().deserializeError(ClassLoader.getSystemClassLoader())).isEqualTo((Object)failure);
        Assertions.assertThat((long)entry.getTimestamp()).isEqualTo(timestamp);
        Assertions.assertThat((String)entry.getFailingTaskName()).isEqualTo("task name");
        Assertions.assertThat((Object)entry.getTaskManagerLocation()).isNull();
        Assertions.assertThat((boolean)entry.isGlobal()).isFalse();
    }
}

