/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.versioning;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.runtime.rest.versioning.RestAPIVersion;
import org.apache.flink.runtime.rest.versioning.RuntimeRestAPIVersion;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RuntimeRestAPIVersionTest {
    RuntimeRestAPIVersionTest() {
    }

    @Test
    void testGetLatest() {
        List<RuntimeRestAPIVersion> candidates = Arrays.asList(RuntimeRestAPIVersion.V0, RuntimeRestAPIVersion.V1);
        Assertions.assertThat((Comparable)((RuntimeRestAPIVersion)RestAPIVersion.getLatestVersion(candidates))).isEqualTo((Object)RuntimeRestAPIVersion.V1);
    }

    @Test
    void testSingleDefaultVersion() {
        List defaultVersions = Arrays.stream(RuntimeRestAPIVersion.values()).filter(RuntimeRestAPIVersion::isDefaultVersion).collect(Collectors.toList());
        ((AbstractIntegerAssert)Assertions.assertThat((int)defaultVersions.size()).as("Only one RestAPIVersion should be marked as the default. Defaults: " + defaultVersions, new Object[0])).isOne();
    }
}

